/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.scanner.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.project.ext.AbstractClassPathMonitor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.JSF2ProjectFactory;
import org.jboss.tools.jst.web.kb.internal.IKbProjectExtension;

public class ClassPathMonitor
extends AbstractClassPathMonitor<IJSF2Project> {
    IPath[] srcs = new IPath[0];
    Set<IPath> removedPaths = new HashSet<IPath>();

    public ClassPathMonitor(IJSF2Project project) {
        this.project = project;
    }

    public void init() {
        this.model = EclipseResourceUtil.createObjectForResource((IResource)this.getProjectResource()).getModel();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, XModelObject> process() {
        HashMap<String, XModelObject> newJars = new HashMap<String, XModelObject>();
        for (String p : this.syncProcessedPaths()) {
            Set<IPath> set = this.removedPaths;
            synchronized (set) {
                this.removedPaths.add((IPath)new Path(p));
            }
        }
        int i = 0;
        while (i < this.paths.size()) {
            XModelObject b;
            XModelObject o;
            String fileName;
            String p = (String)this.paths.get(i);
            if (this.requestForLoad(p) && !EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName = new File(p).getName()) && (o = FileSystemsHelper.getLibs((XModel)this.model).getLibrary(p)) != null && (b = o.getChildByPath("META-INF/web-fragment.xml")) != null) {
                newJars.put(p, b);
            }
            ++i;
        }
        this.validateProjectDependencies();
        return newJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRemovedPaths() {
        Set<IPath> set = this.removedPaths;
        synchronized (set) {
            for (IPath p : this.removedPaths) {
                ((IJSF2Project)this.project).pathRemoved(p);
            }
            this.removedPaths.clear();
        }
    }

    public IProject getProjectResource() {
        return ((IJSF2Project)this.project).getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrcs(IPath[] newSrcs) {
        IPath s;
        HashSet<IPath> ss = new HashSet<IPath>();
        IPath[] iPathArray = newSrcs;
        int n = newSrcs.length;
        int n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            ss.add(s);
            ++n2;
        }
        iPathArray = this.srcs;
        n = this.srcs.length;
        n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            if (!ss.contains(s)) {
                Set<IPath> set = this.removedPaths;
                synchronized (set) {
                    this.removedPaths.add(s);
                }
            }
            ++n2;
        }
        this.srcs = newSrcs;
    }

    public void validateProjectDependencies() {
        List<IJSF2Project> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(((IJSF2Project)this.project).getProject());
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set set = ((IJSF2Project)this.project).getUsedProjects();
            HashSet removable = new HashSet();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (IKbProjectExtension iKbProjectExtension : ps) {
                ((IJSF2Project)this.project).addUsedProject(iKbProjectExtension);
            }
            for (IKbProjectExtension iKbProjectExtension : removable) {
                ((IJSF2Project)this.project).removeUsedProject(iKbProjectExtension);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<IJSF2Project> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(((IJSF2Project)this.project).getProject());
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set set = ((IJSF2Project)this.project).getUsedProjects();
            HashSet removable = new HashSet();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            Iterator<IJSF2Project> iterator = ps.iterator();
            if (iterator.hasNext()) {
                IKbProjectExtension cfr_ignored_0 = iterator.next();
                return true;
            }
            iterator = removable.iterator();
            if (iterator.hasNext()) {
                IKbProjectExtension cfr_ignored_1 = iterator.next();
                return true;
            }
        }
        return false;
    }

    public static List<IJSF2Project> getProjects(IProject project) throws CoreException {
        ArrayList<IJSF2Project> list = new ArrayList<IJSF2Project>();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IJSF2Project sp;
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && (sp = JSF2ProjectFactory.getJSF2Project(p, false)) != null) {
                    list.add(sp);
                }
                ++i;
            }
        }
        return list;
    }

    public synchronized void libraryChanged(String path) {
        super.libraryChanged(path);
        this.removedPaths.add((IPath)new Path(path));
    }
}

