/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.build;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.model.JSF2ProjectFactory;
import org.jboss.tools.jsf.jsf2.bean.model.impl.DefinitionContext;
import org.jboss.tools.jsf.jsf2.bean.model.impl.FacesConfigDefinition;
import org.jboss.tools.jsf.jsf2.bean.model.impl.JSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.impl.TypeDefinition;
import org.jboss.tools.jsf.jsf2.bean.scanner.FileSet;
import org.jboss.tools.jst.web.kb.internal.IIncrementalProjectBuilderExtension;

public class JSF2ProjectBuilder
extends IncrementalProjectBuilder
implements IIncrementalProjectBuilderExtension {
    JSF2ResourceVisitor resourceVisitor = null;
    JSF2Project jsf;

    public JSF2ProjectBuilder() {
    }

    public JSF2ProjectBuilder(JSF2Project jsf) throws CoreException {
        this.jsf = jsf;
        this.build(6, null, (IProgressMonitor)new NullProgressMonitor());
    }

    protected JSF2Project getJSF2Project() {
        if (this.jsf != null) {
            return this.jsf;
        }
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return (JSF2Project)JSF2ProjectFactory.getJSF2Project(p, false);
    }

    IProject getCurrentProject() {
        return this.jsf != null ? this.jsf.getProject() : this.getProject();
    }

    JSF2ResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            this.resourceVisitor = new JSF2ResourceVisitor();
        }
        return this.resourceVisitor;
    }

    public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.resourceVisitor = null;
        JSF2Project n = this.getJSF2Project();
        if (n == null) {
            return null;
        }
        if (n.hasNoStorage()) {
            kind = 6;
        }
        n.postponeFiring();
        try {
            n.resolveStorage(kind != 6);
            if (kind == 6) {
                n.getClassPath().reset();
            }
            boolean isClassPathUpdated = n.getClassPath().update();
            HashMap<String, XModelObject> newJars = new HashMap();
            if (isClassPathUpdated || kind == 6) {
                n.getClassPath().setSrcs(this.getResourceVisitor().srcs);
                newJars = n.getClassPath().process();
            }
            n.getDefinitions().newWorkingCopy(kind == 6);
            if (isClassPathUpdated) {
                n.getClassPath().applyRemovedPaths();
            }
            if (isClassPathUpdated) {
                this.buildJars(newJars);
                n.getClassPath().validateProjectDependencies();
                kind = 6;
            } else if (n.getClassPath().hasToUpdateProjectDependencies()) {
                n.getClassPath().validateProjectDependencies();
            }
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getCurrentProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            this.getJSF2Project().getDefinitions().applyWorkingCopy();
            try {
                n.store();
            }
            catch (IOException e) {
                JSFModelPlugin.getDefault().logError(e);
            }
        }
        finally {
            n.fireChanges();
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            JSF2ResourceVisitor rv = this.getResourceVisitor();
            rv.incremental = false;
            this.getCurrentProject().accept((IResourceVisitor)rv);
            FileSet fs = rv.fileSet;
            this.build(fs, this.getJSF2Project());
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        JSF2ResourceVisitor rv = this.getResourceVisitor();
        rv.incremental = true;
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
        FileSet fs = rv.fileSet;
        this.build(fs, this.getJSF2Project());
    }

    protected void buildJars(Map<String, XModelObject> newJars) throws CoreException {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.getJSF2Project().getProject());
        if (jp == null) {
            return;
        }
        FileSet fileSet = new FileSet();
        for (String jar : newJars.keySet()) {
            IJavaElement[] es;
            Path path = new Path(jar);
            IPackageFragmentRoot root = jp.getPackageFragmentRoot(jar);
            if (root == null) continue;
            if (!root.exists()) {
                IFile f = EclipseResourceUtil.getFile((String)jar);
                if (f != null && f.exists()) {
                    root = jp.getPackageFragmentRoot((IResource)f);
                } else {
                    f = EclipseResourceUtil.getFile((String)(String.valueOf(jar) + "/META-INF/web-fragment.xml"));
                    if (f != null && f.exists()) {
                        root = jp.getPackageFragmentRoot((IResource)f.getParent().getParent());
                    }
                }
            }
            if (root == null || !root.exists()) continue;
            IJavaElement[] iJavaElementArray = es = root.getChildren();
            int n = es.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                if (e instanceof IPackageFragment) {
                    IClassFile[] cs;
                    IPackageFragment pf = (IPackageFragment)e;
                    IClassFile[] iClassFileArray = cs = pf.getClassFiles();
                    int n3 = cs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClassFile c = iClassFileArray[n4];
                        fileSet.add((IPath)path, c.getType());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.build(fileSet, this.getJSF2Project());
    }

    void build(FileSet fs, JSF2Project project) {
        DefinitionContext context = this.getJSF2Project().getDefinitions().getWorkingCopy();
        Map<IPath, Set<IType>> cs = fs.getClasses();
        for (IPath f : cs.keySet()) {
            Set<IType> ts = cs.get(f);
            for (IType type : ts) {
                TypeDefinition def = new TypeDefinition();
                def.setType(type, context, TypeDefinition.FLAG_ALL_MEMBERS);
                context.addType(f, type.getFullyQualifiedName(), def);
            }
        }
        IFile facesConfig = fs.getFacesConfig();
        if (facesConfig != null) {
            FacesConfigDefinition def = new FacesConfigDefinition();
            def.setPath(facesConfig.getFullPath());
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)facesConfig);
            if (o != null) {
                def.setObject(o);
                context.setFacesConfig(def);
            }
        }
    }

    Set<IFile> getDependentFiles(IPath path, Set<IPath> visited) {
        return null;
    }

    class JSF2ResourceVisitor
    implements IResourceVisitor {
        boolean incremental = false;
        FileSet fileSet = new FileSet();
        IPath[] outs = new IPath[0];
        IPath[] srcs = new IPath[0];
        IPath[] webinfs = new IPath[0];
        Set<IPath> visited = new HashSet<IPath>();

        public JSF2ResourceVisitor() {
            this.getJavaSourceRoots(JSF2ProjectBuilder.this.getCurrentProject());
            this.webinfs = WebUtils.getWebInfPaths((IProject)JSF2ProjectBuilder.this.getCurrentProject());
        }

        void getJavaSourceRoots(IProject project) {
            IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                return;
            }
            ArrayList<IPath> ps = new ArrayList<IPath>();
            ArrayList<IPath> os = new ArrayList<IPath>();
            try {
                IPath output = javaProject.getOutputLocation();
                if (output != null) {
                    os.add(output);
                }
                IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < es.length) {
                    if (es[i].getEntryKind() == 3) {
                        IPath out;
                        IResource findMember = ModelPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                        if (findMember != null && findMember.exists()) {
                            ps.add(findMember.getFullPath());
                        }
                        if ((out = es[i].getOutputLocation()) != null && !os.contains(out)) {
                            os.add(out);
                        }
                    }
                    ++i;
                }
                this.srcs = ps.toArray(new IPath[0]);
                this.outs = os.toArray(new IPath[0]);
            }
            catch (CoreException ce) {
                JSFModelPlugin.getDefault().logError("Error while locating java source roots for " + project, ce);
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath path = resource.getFullPath();
            if (resource instanceof IFile) {
                if (this.visited.contains(path)) {
                    return false;
                }
                this.visited.add(path);
                IFile f = (IFile)resource;
                int i = 0;
                while (i < this.outs.length) {
                    if (this.outs[i].isPrefixOf(path)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.srcs.length) {
                    if (this.srcs[i].isPrefixOf(path)) {
                        Set<IFile> ds;
                        ICompilationUnit unit;
                        if (f.getName().endsWith(".java") && (unit = EclipseUtil.getCompilationUnit((IFile)f)) != null) {
                            if (f.getName().equals("package-info.java")) {
                                IPackageDeclaration[] pkg = unit.getPackageDeclarations();
                                if (pkg != null && pkg.length > 0) {
                                    this.fileSet.add(f.getFullPath(), pkg[0]);
                                    if (this.incremental) {
                                        IResource[] ms;
                                        IResource[] iResourceArray = ms = resource.getParent().members();
                                        int n = ms.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IResource m = iResourceArray[n2];
                                            if (m instanceof IFile && !m.getName().equals("package-info.java")) {
                                                this.visit(m);
                                            }
                                            ++n2;
                                        }
                                    }
                                }
                            } else {
                                IType[] ts = unit.getTypes();
                                this.fileSet.add(f.getFullPath(), ts);
                            }
                        }
                        if ((ds = JSF2ProjectBuilder.this.getDependentFiles(path, this.visited)) != null) {
                            for (IFile d : ds) {
                                this.visit((IResource)d);
                            }
                        }
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.webinfs.length) {
                    if (this.webinfs[i].isPrefixOf(path) && f.getName().equals("faces-config.xml") && path.removeLastSegments(1).equals((Object)this.webinfs[i])) {
                        this.fileSet.setFacesConfig(f);
                    }
                    ++i;
                }
                Set<IFile> ds = JSF2ProjectBuilder.this.getDependentFiles(path, this.visited);
                if (ds != null) {
                    for (IFile d : ds) {
                        this.visit((IResource)d);
                    }
                }
            }
            if (resource instanceof IFolder) {
                int i = 0;
                while (i < this.outs.length) {
                    if (this.outs[i].isPrefixOf(path)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.srcs.length) {
                    if (this.srcs[i].isPrefixOf(path) || path.isPrefixOf(this.srcs[i])) {
                        return true;
                    }
                    ++i;
                }
                if (resource == resource.getProject()) {
                    return true;
                }
                IPath[] iPathArray = this.webinfs;
                int n = this.webinfs.length;
                int n3 = 0;
                while (n3 < n) {
                    IPath webinf = iPathArray[n3];
                    if (webinf.isPrefixOf(path) || path.isPrefixOf(webinf)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            return true;
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return JSF2ProjectBuilder.this.getResourceVisitor().visit(resource);
                }
                case 2: {
                    JSF2Project p = JSF2ProjectBuilder.this.getJSF2Project();
                    if (p == null) break;
                    p.getDefinitions().getWorkingCopy().clean(resource.getFullPath());
                    break;
                }
                case 4: {
                    return JSF2ProjectBuilder.this.getResourceVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

