/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private Predicate<E> filter;
    private final ArrayList<E> filteredItems = new ArrayList();

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionModel) {
        this(collectionModel, PredicateTools.true_());
    }

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionModel, Predicate<E> filter) {
        super(collectionModel);
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public FilteringCollectionValueModel(ListValueModel<? extends E> listModel) {
        this(new ListCollectionValueModelAdapter<E>(listModel));
    }

    public FilteringCollectionValueModel(ListValueModel<? extends E> listModel, Predicate<E> filter) {
        this(new ListCollectionValueModelAdapter<E>(listModel), filter);
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.readOnly(this.filteredItems.iterator());
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionModel));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        this.addItemsToCollection(this.filter(this.getItems(event)), this.filteredItems, "values");
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeItemsFromCollection(event.getItems(), this.filteredItems, "values");
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.clearCollection(this.filteredItems, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.rebuildFilteredItems();
    }

    public void setFilter(Predicate<E> filter) {
        this.filter = filter;
        this.rebuildFilteredItems();
    }

    protected Iterable<E> filter(Iterable<? extends E> items) {
        return IterableTools.filter(items, this.filter);
    }

    protected void rebuildFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionModel));
        this.fireCollectionChanged("values", this.filteredItems);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.filteredItems);
    }
}

