/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterator<? extends Iterator<? extends E>> iterators;
    private Iterator<? extends E> currentIterator;
    private Iterator<? extends E> lastIteratorToReturnNext;

    public CompositeIterator(Iterator<? extends Iterator<? extends E>> iterators) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadCurrentIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.loadCurrentIterator();
        E result = this.currentIterator.next();
        this.lastIteratorToReturnNext = this.currentIterator;
        return result;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnNext == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnNext.remove();
    }

    private void loadCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.next();
        }
        while (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

