/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<L>
implements Iterable<L> {
    private volatile transient L[] listeners;

    public ListenerList(Class<L> listenerClass) {
        this.listeners = this.buildListenerArray(listenerClass, 0);
    }

    public ListenerList(Class<L> listenerClass, L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners = this.buildListenerArray(listenerClass, 1);
        this.listeners[0] = listener;
    }

    private L[] buildListenerArray(Class<L> listenerClass, int length) {
        return (Object[])Array.newInstance(listenerClass, length);
    }

    @Override
    public Iterator<L> iterator() {
        return IteratorTools.iterator(this.listeners);
    }

    public int size() {
        return this.listeners.length;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (ArrayTools.contains(this.listeners, listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
        this.listeners = ArrayTools.add(this.listeners, listener);
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int index = ArrayTools.indexOf(this.listeners, listener);
        if (index == -1) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        this.listeners = ArrayTools.removeElementAtIndex(this.listeners, index);
    }

    public synchronized void clear() {
        this.listeners = ArrayTools.clear(this.listeners);
    }

    public Class<L> getListenerType() {
        return this.listeners.getClass().getComponentType();
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this.listeners);
    }
}

