/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jboss.tools.cordovasim.eclipse.Activator;
import org.jboss.tools.cordovasim.eclipse.internal.util.CordovaFileUtil;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.ConfigXMLServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.CordovaJsServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.CordovaPluginJsServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.CrossOriginProxyServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.FormatDataServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.HostFileServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.PluginServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.StaticResponseServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.UploadFileServlet;
import org.jboss.tools.cordovasim.eclipse.servlet.internal.WorkspaceFileServlet;
import org.osgi.framework.Bundle;

public class ServerCreator {
    private static final String CORDOVASIM_RIPPLE_BUNDLE = "org.jboss.tools.cordovasim.ripple";
    private static final String RIPPLE_FOLDER = "ripple";
    private static final String RIPPLE_CORDOVA_FOLDER = "ripple/cordova";
    private static final String LOCALHOST = "localhost";

    public static Server createServer(IProject project, IContainer resourceBase, String cordovaEngineLocation, Integer port) {
        QueuedThreadPool threadPool = new QueuedThreadPool(100, 10);
        Server server = new Server((ThreadPool)threadPool);
        server.manage((Object)threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setReuseAddress(false);
        connector.setSoLingerTime(0);
        connector.setHost(LOCALHOST);
        connector.setPort(ServerCreator.setupPort(port));
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler rippleContext = new ServletContextHandler(1);
        rippleContext.setContextPath("/");
        ServletHolder cordovaJsServletHolder = new ServletHolder((Servlet)new CordovaJsServlet(cordovaEngineLocation));
        rippleContext.addServlet(cordovaJsServletHolder, "/cordova.js");
        String ripplePath = ServerCreator.getResoursePathFromBundle(RIPPLE_FOLDER, CORDOVASIM_RIPPLE_BUNDLE);
        ServletHolder rippleHome = new ServletHolder("ripple-home", DefaultServlet.class);
        rippleHome.setInitParameter("resourceBase", ripplePath);
        rippleHome.setInitParameter("pathInfoOnly", "true");
        rippleHome.setInitParameter("dirAllowed", "true");
        rippleContext.addServlet(rippleHome, "/ripple/assets/*");
        ServletHolder userAgentServletHolder = new ServletHolder((Servlet)new StaticResponseServlet("OK"));
        rippleContext.addServlet(userAgentServletHolder, "/ripple/user-agent");
        ServletHolder configXMLHolder = new ServletHolder((Servlet)new ConfigXMLServlet(project));
        rippleContext.addServlet(configXMLHolder, "/config.xml");
        String wwwLocation = resourceBase.getRawLocation().makeAbsolute().toOSString();
        File pluginDir = CordovaFileUtil.getPluginDir(wwwLocation);
        ServletHolder cordovaPluginJsServletHolder = new ServletHolder((Servlet)new CordovaPluginJsServlet(pluginDir));
        rippleContext.addServlet(cordovaPluginJsServletHolder, "/cordova_plugins.js");
        String cordovaLocation = ServerCreator.getResoursePathFromBundle(RIPPLE_CORDOVA_FOLDER, CORDOVASIM_RIPPLE_BUNDLE);
        ServletHolder cordovaHome = new ServletHolder("cordova-home", DefaultServlet.class);
        cordovaHome.setInitParameter("resourceBase", cordovaLocation);
        cordovaHome.setInitParameter("dirAllowed", "true");
        cordovaHome.setInitParameter("pathInfoOnly", "true");
        rippleContext.addServlet(cordovaHome, "/ripple/cordova/*");
        ServletHolder pluginServletHolder = new ServletHolder((Servlet)new PluginServlet(pluginDir));
        rippleContext.addServlet(pluginServletHolder, "/plugins/*");
        ServletHolder proxyServletHolder = new ServletHolder((Servlet)new CrossOriginProxyServlet("tinyhippos_rurl"));
        proxyServletHolder.setAsyncSupported(true);
        proxyServletHolder.setInitParameter("maxThreads", "10");
        rippleContext.addServlet(proxyServletHolder, "/ripple/xhr_proxy");
        ServletHolder uploadFileServletHolder = new ServletHolder((Servlet)new UploadFileServlet());
        uploadFileServletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(null, 0x100000L, 0x100000L, 262144));
        rippleContext.addServlet(uploadFileServletHolder, "/ripple/fileUpload");
        ServletHolder hostFileServletHolder = new ServletHolder((Servlet)new HostFileServlet());
        rippleContext.addServlet(hostFileServletHolder, "/temp-photo/*");
        ServletHolder formatDataServletHolder = new ServletHolder((Servlet)new FormatDataServlet());
        rippleContext.addServlet(formatDataServletHolder, "/ripple/formatData");
        String workspaceResoureLocation = "/" + project.getName() + "/" + resourceBase.getProjectRelativePath().toOSString();
        ServletHolder workspaceServletHolder = new ServletHolder((Servlet)new WorkspaceFileServlet(workspaceResoureLocation));
        rippleContext.addServlet(workspaceServletHolder, "/");
        RewriteHandler rippleRewriteHandler = new RewriteHandler();
        rippleRewriteHandler.setRewriteRequestURI(true);
        rippleRewriteHandler.setRewritePathInfo(true);
        rippleRewriteHandler.setHandler((Handler)rippleContext);
        rippleRewriteHandler.addRule(new Rule(){

            public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
                if (request.getParameter("enableripple") != null) {
                    return "/ripple/assets/index.html";
                }
                return null;
            }
        });
        server.setHandler((Handler)rippleRewriteHandler);
        return server;
    }

    private static int setupPort(Integer port) {
        return port != null ? port : 0;
    }

    private static String getResoursePathFromBundle(String path, String bundleName) {
        String resourcePath = null;
        Bundle bundle = Platform.getBundle((String)bundleName);
        URL fileURL = bundle.getEntry(path);
        try {
            URL resolvedFileURL = FileLocator.toFileURL((URL)fileURL);
            URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            File file = new File(resolvedURI);
            if (file != null && file.exists()) {
                resourcePath = file.getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return resourcePath;
    }
}

