/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.wizard;

import org.eclipse.core.databinding.validation.IValidator;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueWizardModel;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizardModel;

public class KeyValueWizardModelBuilder<T extends IKeyValueItem> {
    private String title;
    private String description;
    private IValidator keyAfterConvertValidator;
    private String groupLabel;
    private IValidator valueAfterConvertValidator;
    private String key;
    private String value;
    private String keyLabel = "Name";
    private String valueLabel = "Value";
    private String windowTitle = "";

    public KeyValueWizardModelBuilder() {
        this(null);
    }

    public KeyValueWizardModelBuilder(T label) {
        if (label == null) {
            return;
        }
        this.key = label.getKey();
        this.value = label.getValue();
    }

    public IKeyValueWizardModel<T> build() {
        KeyValueWizardModel model = new KeyValueWizardModel(this.windowTitle, this.title, this.keyLabel, this.valueLabel, this.description, this.groupLabel, this.keyAfterConvertValidator, this.valueAfterConvertValidator);
        model.setKey(this.key);
        model.setValue(this.value);
        return model;
    }

    public KeyValueWizardModelBuilder<T> keyLabel(String label) {
        this.keyLabel = label;
        return this;
    }

    public KeyValueWizardModelBuilder<T> valueLabel(String label) {
        this.valueLabel = label;
        return this;
    }

    public KeyValueWizardModelBuilder<T> title(String title) {
        this.title = title;
        return this;
    }

    public KeyValueWizardModelBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public KeyValueWizardModelBuilder<T> keyAfterConvertValidator(IValidator validator) {
        this.keyAfterConvertValidator = validator;
        return this;
    }

    public KeyValueWizardModelBuilder<T> valueAfterConvertValidator(IValidator validator) {
        this.valueAfterConvertValidator = validator;
        return this;
    }

    public KeyValueWizardModelBuilder<T> groupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
        return this;
    }

    public KeyValueWizardModelBuilder<T> windowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
        return this;
    }
}

