/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableViewerBuilder {
    private TableViewer viewer;
    private TableColumnLayout tableLayout;

    public TableViewerBuilder(Table table, Composite tableContainer) {
        this(new TableViewer(table), tableContainer);
    }

    public TableViewerBuilder(TableViewer viewer, Composite tableContainer) {
        this.viewer = viewer;
        viewer.setComparer((IElementComparer)new EqualityComparer());
        this.tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)this.tableLayout);
    }

    public TableViewerBuilder contentProvider(IStructuredContentProvider contentProvider) {
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        return this;
    }

    public TableViewerBuilder comparer(IElementComparer sorter) {
        this.viewer.setComparer(sorter);
        return this;
    }

    public TableViewerBuilder sorter(ViewerSorter sorter) {
        this.viewer.setSorter(sorter);
        return this;
    }

    public <E> ColumnBuilder<E> column(String name) {
        return new ColumnBuilder().name(name);
    }

    public <E> ColumnBuilder<E> column(IColumnLabelProvider<E> columnLabelProvider) {
        return new ColumnBuilder<E>().labelProvider(columnLabelProvider);
    }

    public TableViewer buildViewer() {
        return this.viewer;
    }

    public class ColumnBuilder<E> {
        private int alignement;
        private IColumnLabelProvider<E> columnLabelProvider;
        private ICellToolTipProvider<E> cellToolTipProvider;
        private String name;
        private int weight;
        private int minWidth = 20;

        private ColumnBuilder() {
        }

        public ColumnBuilder<E> labelProvider(IColumnLabelProvider<E> labelProvider) {
            this.columnLabelProvider = labelProvider;
            return this;
        }

        public ColumnBuilder<E> cellToolTipProvider(ICellToolTipProvider<E> cellToolTipProvider) {
            this.cellToolTipProvider = cellToolTipProvider;
            return this;
        }

        public ColumnBuilder<E> align(int alignement) {
            this.alignement = alignement;
            return this;
        }

        public ColumnBuilder<E> name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder<E> weight(int weight) {
            this.weight = weight;
            return this;
        }

        public ColumnBuilder<E> minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public TableViewerBuilder buildColumn() {
            if (this.cellToolTipProvider != null) {
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)TableViewerBuilder.this.viewer, (int)2);
            }
            TableViewerColumn column = new TableViewerColumn(TableViewerBuilder.this.viewer, this.alignement);
            column.getColumn().setText(this.name);
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    String cellValue = ColumnBuilder.this.columnLabelProvider.getValue(cell.getElement());
                    cell.setText(cellValue);
                }

                public String getToolTipText(Object object) {
                    if (ColumnBuilder.this.cellToolTipProvider != null) {
                        return ColumnBuilder.this.cellToolTipProvider.getToolTipText(object);
                    }
                    return super.getToolTipText(object);
                }

                public int getToolTipDisplayDelayTime(Object element) {
                    if (ColumnBuilder.this.cellToolTipProvider != null) {
                        return ColumnBuilder.this.cellToolTipProvider.getToolTipDisplayDelayTime(element);
                    }
                    return super.getToolTipDisplayDelayTime(element);
                }
            });
            TableViewerBuilder.this.tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.weight, this.minWidth, true));
            return TableViewerBuilder.this;
        }
    }

    public static class EqualityComparer
    implements IElementComparer {
        public boolean equals(Object thisObject, Object thatObject) {
            if (thisObject == null) {
                return thatObject != null;
            }
            if (thatObject == null) {
                return false;
            }
            return thisObject.equals(thatObject);
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }
    }

    public static interface ICellToolTipProvider<T> {
        public String getToolTipText(T var1);

        public int getToolTipDisplayDelayTime(T var1);
    }

    public static interface IColumnLabelProvider<E> {
        public String getValue(E var1);
    }
}

