/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class HttpsPrefixingAdapter {
    private static final String HTTP_SCHEME = "http://";
    private static final String HTTPS_SCHEME = "https://";

    public void addTo(final Text text) {
        text.addKeyListener((KeyListener)new SchemePrefixingKeyAdapter(this){

            @Override
            protected int getCursorPosition() {
                return text.getCaretPosition();
            }

            @Override
            protected void setCursorPosition(int pos) {
                text.setSelection(pos);
            }

            @Override
            protected String getText() {
                return text.getText();
            }

            @Override
            protected void setText(String string) {
                text.setText(string);
            }
        });
    }

    public void addTo(final Combo combo) {
        combo.addKeyListener((KeyListener)new SchemePrefixingKeyAdapter(this){

            @Override
            protected int getCursorPosition() {
                return combo.getCaretPosition();
            }

            @Override
            protected void setCursorPosition(int pos) {
                combo.setSelection(new Point(pos, pos));
            }

            @Override
            protected String getText() {
                return combo.getText();
            }

            @Override
            protected void setText(String string) {
                combo.setText(string);
            }
        });
    }

    protected abstract class SchemePrefixingKeyAdapter
    extends KeyAdapter {
        protected SchemePrefixingKeyAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            if (!this.isCharacter(e.character)) {
                return;
            }
            String serverUrl = this.getText();
            String serverUrlBeginning = serverUrl.substring(0, this.getCursorPosition());
            if (this.matchesAllOrSubstring(serverUrlBeginning, HttpsPrefixingAdapter.HTTP_SCHEME) || this.matchesAllOrSubstring(serverUrlBeginning, HttpsPrefixingAdapter.HTTPS_SCHEME)) {
                return;
            }
            serverUrl = HttpsPrefixingAdapter.HTTPS_SCHEME + serverUrl;
            this.setText(serverUrl);
            this.setCursorPosition(serverUrl.length());
        }

        private boolean isCharacter(char character) {
            return character != '\r' && character != '\t' && character != '\u007f' && character != '\b' && character != '\u10000' && character != '\u40000' && character != '\u20000' && character != '\u001b' && character != '\u1000007' && character != '\b' && character != '\u1000006' && character != '\u1000005' && character != '\t' && character != '\u0000';
        }

        protected boolean matchesAllOrSubstring(String inspected, String requiredBeginning) {
            return inspected.startsWith(requiredBeginning.substring(0, Math.min(requiredBeginning.length(), inspected.length())));
        }

        protected abstract int getCursorPosition();

        protected abstract void setCursorPosition(int var1);

        protected abstract String getText();

        protected abstract void setText(String var1);
    }
}

