/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.explorer;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;

public abstract class BaseExplorerLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof IConnection) {
            return OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_ICON_IMG;
        }
        if (element instanceof BaseExplorerContentProvider.LoadingStub) {
            return OpenShiftCommonImages.SYSTEM_PROCESS_IMG;
        }
        if (element instanceof Exception) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        return null;
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof BaseExplorerContentProvider.LoadingStub) {
            return new StyledString("Loading...");
        }
        if (element instanceof Exception) {
            Exception exception = (Exception)element;
            return new StyledString(StringUtils.defaultIfBlank((String)exception.getMessage(), (String)exception.getClass().getName()));
        }
        return new StyledString(element.toString());
    }
}

