/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.detailviews;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;

public abstract class AbstractStackedDetailViews {
    protected final IDetailView emptyView;
    private Composite parent;
    private IDetailView currentView;
    private final StackLayout stackLayout;
    private Object context;
    private DataBindingContext dbc;
    private IObservableValue detailViewModel;

    public AbstractStackedDetailViews(IObservableValue detailViewModel, Object context, Composite parent, DataBindingContext dbc) {
        this.currentView = this.emptyView = new EmptyView();
        this.stackLayout = new StackLayout();
        Assert.isLegal((parent != null && !parent.isDisposed() ? 1 : 0) != 0);
        this.parent = parent;
        parent.addDisposeListener(this.onDispose());
        this.context = context;
        Assert.isLegal((dbc != null ? 1 : 0) != 0);
        this.dbc = dbc;
        Assert.isLegal((detailViewModel != null && !detailViewModel.isDisposed() ? 1 : 0) != 0);
        this.detailViewModel = detailViewModel;
    }

    public void createControls() {
        this.createControls(true);
    }

    public void createControls(boolean showView) {
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)this.onDetailViewModelChanged(this.detailViewModel), (IObservableValue)this.detailViewModel, (Control)this.parent);
        this.parent.setLayout((Layout)this.stackLayout);
        this.createViewControls(this.parent, this.context, this.dbc);
        if (showView) {
            this.showView(this.detailViewModel, this.getView(this.detailViewModel), this.dbc);
        }
    }

    protected abstract IDetailView[] getDetailViews();

    private IValueChangeListener onDetailViewModelChanged(IObservableValue detailViewsModel) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractStackedDetailViews.this.showView(event.getObservableValue(), AbstractStackedDetailViews.this.dbc);
            }
        };
    }

    protected void showView(IObservableValue detailViewsModel, DataBindingContext dbc) {
        this.showView(detailViewsModel, this.getView(detailViewsModel), dbc);
    }

    protected void showView(IObservableValue detailViewsModel, IDetailView view, DataBindingContext dbc) {
        if (view == null || view.getControl() == null || detailViewsModel == null) {
            return;
        }
        this.currentView.onInVisible(detailViewsModel, dbc);
        this.currentView = view;
        view.onVisible(detailViewsModel, dbc);
        this.stackLayout.topControl = view.getControl();
        this.parent.layout(true, true);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.emptyView.createControls(parent, context, dbc);
        IDetailView[] iDetailViewArray = this.getDetailViews();
        int n = iDetailViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailView detailView = iDetailViewArray[n2];
            detailView.createControls(parent, context, dbc);
            ++n2;
        }
    }

    protected IDetailView getView(IObservableValue detailViewsModel) {
        return this.getViewFor(detailViewsModel, this.getDetailViews());
    }

    protected IDetailView getViewFor(IObservableValue detailViewsModel, IDetailView ... detailViews) {
        Object value = detailViewsModel.getValue();
        IDetailView view = this.createControls(this.emptyView);
        IDetailView[] iDetailViewArray = detailViews;
        int n = detailViews.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailView detailView = iDetailViewArray[n2];
            if (detailView.isViewFor(value)) {
                view = detailView;
                break;
            }
            ++n2;
        }
        if (view == null) {
            OpenShiftCommonCoreActivator.pluginLog().logWarning(NLS.bind((String)"No view found to display value {0}", (Object)value));
        }
        return view;
    }

    private IDetailView createControls(IDetailView view) {
        if (view == null) {
            return null;
        }
        if (view.getControl() == null) {
            view.createControls(this.parent, view, this.dbc);
        }
        return view;
    }

    private DisposeListener onDispose() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractStackedDetailViews.this.dispose();
            }
        };
    }

    private void dispose() {
        IDetailView[] iDetailViewArray = this.getDetailViews();
        int n = iDetailViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailView view = iDetailViewArray[n2];
            if (view != null) {
                view.dispose();
            }
            ++n2;
        }
    }

    protected IDetailView getCurrentView() {
        return this.currentView;
    }

    public class EmptyView
    extends BaseDetailsView {
        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(6, 6).spacing(6, 6).applyTo(container);
            return container;
        }

        @Override
        public boolean isViewFor(Object object) {
            return false;
        }
    }

    public static interface IDetailView {
        public Composite createControls(Composite var1, Object var2, DataBindingContext var3);

        public void onVisible(IObservableValue var1, DataBindingContext var2);

        public void onInVisible(IObservableValue var1, DataBindingContext var2);

        public Control getControl();

        public boolean isViewFor(Object var1);

        public void dispose();
    }
}

