/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.connection.ConnectionsFactoryTracker;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.common.core.connection.IConnectionsFactory;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;

public class ConnectionWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_CONNECTION = "selectedConnection";
    public static final String PROPERTY_CONNECTION_FACTORY = "connectionFactory";
    public static final String PROPERTY_CONNECTION_FACTORY_ERROR = "connectionFactoryError";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_USE_DEFAULT_HOST = "useDefaultHost";
    public static final String PROPERTY_ALL_HOSTS = "allHosts";
    public static final String PROPERTY_CONNECT_ERROR = "connectError";
    private IConnection selectedConnection;
    private IConnection connection;
    private IStatus connectionFactoryError;
    private String host;
    private boolean allowConnectionChange;
    private IConnectionFactory connectionFactory;
    private boolean useDefaultHost;
    private Collection<String> allHosts;
    private ConnectionsFactoryTracker connectionsFactory;
    private IStatus connectError;
    private IConnectionAuthenticationProvider connectionAuthenticationProvider;
    private Collection<IConnection> allConnections;
    private IConnectionAware<IConnection> wizardModel;

    ConnectionWizardPageModel(IConnection editedConnection, Collection<IConnection> allConnections, boolean allowConnectionChange, IConnectionAware<IConnection> wizardModel) {
        this.allConnections = allConnections;
        this.wizardModel = wizardModel;
        this.allHosts = this.createAllHosts(allConnections);
        this.allowConnectionChange = allowConnectionChange;
        this.connectionsFactory = this.createConnectionsFactory();
        this.init(editedConnection);
    }

    private Collection<String> createAllHosts(Collection<IConnection> allConnections) {
        ArrayList<String> allHosts = new ArrayList<String>();
        if (allConnections == null) {
            return allHosts;
        }
        for (IConnection connection : allConnections) {
            if (StringUtils.isEmpty((String)connection.getHost())) continue;
            allHosts.add(connection.getHost());
        }
        return allHosts;
    }

    private ConnectionsFactoryTracker createConnectionsFactory() {
        ConnectionsFactoryTracker connectionsFactory = new ConnectionsFactoryTracker();
        connectionsFactory.open();
        return connectionsFactory;
    }

    private void init(IConnection editedConnection) {
        this.connectError = Status.OK_STATUS;
        this.connectionFactoryError = Status.OK_STATUS;
        if (editedConnection == null) {
            this.initNewConnection();
        } else {
            this.initEditConnection(editedConnection);
        }
    }

    private void initEditConnection(IConnection connection) {
        this.selectedConnection = connection;
        this.connection = connection.clone();
        this.connectionFactory = this.connectionsFactory.getByConnection(connection.getClass());
        this.host = connection.getHost();
        this.useDefaultHost = connection.isDefaultHost();
    }

    private void initNewConnection() {
        this.selectedConnection = NewConnectionMarker.getInstance();
        this.connectionFactory = this.getDefaultConnectionFactory((IConnectionsFactory)this.connectionsFactory);
        if (this.connectionFactory != null) {
            this.host = this.connectionFactory.getDefaultHost();
            this.useDefaultHost = this.connectionFactory.hasDefaultHost();
            if (this.host != null) {
                this.connection = this.connectionFactory.create(this.host);
            }
        }
    }

    private IConnectionFactory getDefaultConnectionFactory(IConnectionsFactory connectionsFactory) {
        IConnectionFactory factory = connectionsFactory.getById("org.jboss.tools.openshift.express.core.ConnectionFactory");
        if (factory == null) {
            factory = connectionsFactory.getById("org.jboss.tools.openshift.core.ConnectionFactory");
        }
        return factory;
    }

    private void update(IConnection selectedConnection, IConnectionFactory factory, String host, boolean useDefaultHost, IStatus connectionFactoryError, IStatus connectError) {
        factory = this.updateFactory(factory, selectedConnection);
        useDefaultHost = this.updateUseDefaultHost(useDefaultHost, selectedConnection, factory);
        host = this.updateHost(host, useDefaultHost, selectedConnection, factory);
        this.selectedConnection = selectedConnection;
        this.firePropertyChange(PROPERTY_SELECTED_CONNECTION, this.selectedConnection, this.selectedConnection);
        this.connectionFactory = factory;
        this.firePropertyChange(PROPERTY_CONNECTION_FACTORY, this.connectionFactory, this.connectionFactory);
        this.host = host;
        this.firePropertyChange(PROPERTY_HOST, this.host, this.host);
        this.useDefaultHost = useDefaultHost;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_HOST, this.useDefaultHost, this.useDefaultHost);
        this.setConnectionFactoryError(connectionFactoryError);
        this.setConnectError(connectError);
    }

    private IConnectionFactory updateFactory(IConnectionFactory factory, IConnection selectedConnection) {
        if (selectedConnection instanceof NewConnectionMarker) {
            return factory;
        }
        if (!selectedConnection.equals(this.selectedConnection) && !(selectedConnection instanceof NewConnectionMarker)) {
            factory = this.connectionsFactory.getByConnection(selectedConnection.getClass());
        }
        return factory;
    }

    private String updateHost(String host, boolean useDefaultHost, IConnection selectedConnection, IConnectionFactory factory) {
        if (!(selectedConnection instanceof NewConnectionMarker) && !selectedConnection.equals(this.selectedConnection)) {
            host = selectedConnection.getHost();
        } else if (factory != null && useDefaultHost && !StringUtils.isEmpty((String)factory.getDefaultHost())) {
            host = factory.getDefaultHost();
        }
        return host;
    }

    private boolean updateUseDefaultHost(boolean useDefaultHost, IConnection selectedConnection, IConnectionFactory factory) {
        if (factory != null && !factory.equals(this.connectionFactory)) {
            if (useDefaultHost) {
                useDefaultHost = factory.hasDefaultHost();
            }
        } else if (selectedConnection != null && !selectedConnection.equals(this.selectedConnection)) {
            useDefaultHost = selectedConnection.isDefaultHost();
        }
        return useDefaultHost;
    }

    private boolean isNewConnection() {
        return this.selectedConnection instanceof NewConnectionMarker;
    }

    public void setSelectedConnection(IConnection selectedConnection) {
        this.update(selectedConnection, this.connectionFactory, this.host, this.useDefaultHost, Status.OK_STATUS, Status.OK_STATUS);
    }

    public IConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnectionFactory(IConnectionFactory factory) {
        this.update((IConnection)NewConnectionMarker.getInstance(), factory, this.host, this.useDefaultHost, Status.OK_STATUS, Status.OK_STATUS);
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Collection<IConnection> getAllConnections() {
        if (this.allowConnectionChange) {
            ArrayList<IConnection> connections = new ArrayList<IConnection>();
            connections.add((IConnection)NewConnectionMarker.getInstance());
            connections.addAll(this.allConnections);
            return connections;
        }
        return Collections.singletonList(this.selectedConnection);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.update(this.selectedConnection, this.connectionFactory, host, this.useDefaultHost, Status.OK_STATUS, Status.OK_STATUS);
    }

    private void setConnectionFactoryError(IStatus status) {
        this.connectionFactoryError = status;
        this.firePropertyChange(PROPERTY_CONNECTION_FACTORY_ERROR, this.connectionFactoryError, this.connectionFactoryError);
    }

    public IStatus getConnectionFactoryError() {
        return this.connectionFactoryError;
    }

    public void setUseDefaultHost(boolean useDefaultHost) {
        this.update(this.selectedConnection, this.connectionFactory, this.host, useDefaultHost, Status.OK_STATUS, Status.OK_STATUS);
    }

    public boolean isUseDefaultHost() {
        return this.useDefaultHost;
    }

    public void setAllHosts(Collection<String> allHosts) {
        this.allHosts = allHosts;
        this.firePropertyChange(PROPERTY_ALL_HOSTS, this.allHosts, this.allHosts);
    }

    public Collection<String> getAllHosts() {
        return this.allHosts;
    }

    public IStatus connect() {
        IStatus status = Status.OK_STATUS;
        try {
            this.connection = this.createConnection();
            if (this.connection != null) {
                if (this.connection.connect()) {
                    this.wizardModel.setConnection(this.connection);
                } else {
                    String message = NLS.bind((String)"Unable to connect to {0}", (Object)this.connection.getHost());
                    OpenShiftCommonUIActivator.log(message, null);
                    status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)message);
                }
            }
        }
        catch (Exception e) {
            status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"The server type, credentials, or auth scheme might be incorrect. {0}", (Object)e.getMessage()));
            OpenShiftCommonUIActivator.log(e);
        }
        this.update(this.selectedConnection, this.connectionFactory, this.host, this.useDefaultHost, Status.OK_STATUS, status);
        return status;
    }

    private IConnection createConnection() {
        if (this.connectionFactory == null) {
            return null;
        }
        IConnection connection = this.connectionFactory.create(this.getHost());
        if (connection == null) {
            return null;
        }
        if (this.connectionAuthenticationProvider != null) {
            this.connectionAuthenticationProvider.update(connection);
        }
        return connection;
    }

    public void resetConnectError() {
        this.setConnectError(Status.OK_STATUS);
    }

    private void setConnectError(IStatus status) {
        this.connectError = status;
        this.firePropertyChange(PROPERTY_CONNECT_ERROR, this.connectError, this.connectError);
    }

    public IStatus getConnectError() {
        return this.connectError;
    }

    public void saveRecentConnection() {
    }

    public Collection<IConnectionFactory> getAllConnectionFactories() {
        ArrayList<IConnectionFactory> connectionFactories = new ArrayList<IConnectionFactory>();
        connectionFactories.addAll(this.connectionsFactory.getAll());
        return connectionFactories;
    }

    public void dispose() {
        this.connectionsFactory.close();
    }

    public boolean saveConnection() {
        if (this.connection == null || !this.connectError.isOK()) {
            return false;
        }
        if (this.isNewConnection()) {
            ConnectionsRegistrySingleton.getInstance().add(this.connection);
        } else {
            this.getSelectedConnection().update(this.connection);
        }
        return true;
    }

    public void setConnectionAuthenticationProvider(IConnectionAuthenticationProvider authenticationProvider) {
        this.connectionAuthenticationProvider = authenticationProvider;
    }

    public Object getContext() {
        return this.wizardModel.getContext();
    }

    public static interface IConnectionAuthenticationProvider {
        public IConnection update(IConnection var1);
    }
}

