/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.ui.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardModel;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPage;
import org.jboss.tools.openshift.internal.common.ui.utils.ExtensionUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAwareWizard;

public abstract class AbstractApplicationWorkbenchWizard
extends Wizard
implements IWorkbenchWizard {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CONNECTION = "connection";
    private Map<Class<IConnection>, IConnectionAwareWizard<IConnection>> wizardsByConnection;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    protected AbstractApplicationWorkbenchWizard(String title) {
        this.setWindowTitle(title);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    protected IConnectionAwareWizard<IConnection> getWizard(Class<? extends IConnection> connectionClass) {
        return this.getWizards().get(connectionClass);
    }

    private Map<Class<IConnection>, IConnectionAwareWizard<IConnection>> getWizards() {
        if (this.wizardsByConnection == null) {
            this.wizardsByConnection = this.createWizards(this.getWizardsExtensionId());
        }
        return this.wizardsByConnection;
    }

    protected Map<Class<IConnection>, IConnectionAwareWizard<IConnection>> createWizards(String extensionId) {
        HashMap<Class<IConnection>, IConnectionAwareWizard<IConnection>> wizardsByConnection = new HashMap<Class<IConnection>, IConnectionAwareWizard<IConnection>>();
        for (IConfigurationElement configuration : ExtensionUtils.getExtensionConfigurations(extensionId)) {
            this.createWizard(wizardsByConnection, configuration);
        }
        return wizardsByConnection;
    }

    private void createWizard(HashMap<Class<IConnection>, IConnectionAwareWizard<IConnection>> wizardsByConnection, IConfigurationElement configuration) {
        try {
            Class connectionClass;
            IConnectionAwareWizard wizard = (IConnectionAwareWizard)ExtensionUtils.createExtension(ATTRIBUTE_CLASS, configuration);
            if (wizard != null && (connectionClass = ExtensionUtils.getClass(configuration.getAttribute(ATTRIBUTE_CONNECTION), configuration)) != null) {
                wizardsByConnection.put(connectionClass, wizard);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | IllegalStateException | InvalidRegistryObjectException e) {
            OpenShiftCommonUIActivator.log(NLS.bind((String)"Could not create application wizard in bundle {0} for extension {1}", (Object)ExtensionUtils.getBundleNameFor(configuration), (Object)configuration.getName()), e);
        }
    }

    public boolean performFinish() {
        return false;
    }

    public void addPages() {
        this.addPage((IWizardPage)new DelegatingConnectionWizardPage((IWizard)this, new ConnectionWizardModel(ConnectionsRegistrySingleton.getInstance().getRecentConnection(), null)));
    }

    protected abstract String getWizardsExtensionId();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    protected class DelegatingConnectionWizardPage
    extends ConnectionWizardPage {
        private IObservableValue validationStatus;

        private DelegatingConnectionWizardPage(IWizard wizard, IConnectionAware<IConnection> wizardModel) {
            super(wizard, wizardModel);
        }

        public boolean isPageComplete() {
            return false;
        }

        public boolean canFlipToNextPage() {
            return this.hasWizard(this.getModel().getConnectionFactory()) && this.isValid();
        }

        private boolean isValid() {
            IStatus status = (IStatus)this.getValidationStatus().getValue();
            return status == null || status.isOK();
        }

        private IObservableValue getValidationStatus() {
            if (this.validationStatus == null) {
                this.validationStatus = new AggregateValidationStatus(this.getDatabindingContext(), 2);
            }
            return this.validationStatus;
        }

        public IWizardPage getNextPage() {
            if (!this.connect()) {
                return null;
            }
            IConnection connection = this.getConnection();
            if (connection == null) {
                return null;
            }
            IConnectionAwareWizard<IConnection> wizard = this.getWizard(connection);
            if (wizard == null) {
                return null;
            }
            wizard.setConnection(connection);
            return wizard.getStartingPage();
        }

        private IConnectionAwareWizard<IConnection> getWizard(IConnection connection) {
            if (connection == null) {
                return null;
            }
            IConnectionAwareWizard<IConnection> wizard = AbstractApplicationWorkbenchWizard.this.getWizard(connection.getClass());
            if (wizard == null) {
                return null;
            }
            if (wizard.getPageCount() == 0) {
                if (wizard instanceof IWorkbenchWizard) {
                    ((IWorkbenchWizard)wizard).init(AbstractApplicationWorkbenchWizard.this.workbench, AbstractApplicationWorkbenchWizard.this.selection);
                }
                wizard.addPages();
            }
            return wizard;
        }

        private boolean hasWizard(IConnectionFactory factory) {
            if (factory == null) {
                return false;
            }
            IConnection connection = factory.create(this.getModel().getHost());
            if (connection == null) {
                return false;
            }
            IConnectionAwareWizard<IConnection> wizard = AbstractApplicationWorkbenchWizard.this.getWizard(connection.getClass());
            if (wizard == null) {
                this.setErrorMessage(NLS.bind((String)"No wizard for {0} connections present.", (Object)this.getModel().getConnectionFactory().getName()));
            }
            return wizard != null;
        }
    }
}

