/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard.workflow;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.internal.wizard.workflow.DownloadManagerTermsAndConditionsFragment;

public class DownloadManagerWorkflowUtility {
    public static final int AUTHORIZED = 1;
    public static final int CREDENTIALS_FAILED = 2;
    public static final int WORKFLOW_FAILED = 3;

    public static int getWorkflowStatus(DownloadRuntime dr, String userS, String passS) throws CoreException, MalformedURLException, IOException {
        int response = DownloadManagerWorkflowUtility.headerOnlyStatusCode(dr, userS, passS);
        if (response == 401) {
            return 2;
        }
        if (response == 403 || response == 200) {
            return 3;
        }
        if (response == 302) {
            return 1;
        }
        throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.ui", "Unknown response code: " + response));
    }

    private static int headerOnlyStatusCode(DownloadRuntime dr, String userS, String passS) throws CoreException, MalformedURLException, IOException {
        HttpURLConnection con = DownloadManagerWorkflowUtility.getWorkflowConnection(dr, userS, passS, "HEAD", true);
        int response = con.getResponseCode();
        con.disconnect();
        return response;
    }

    private static HttpURLConnection getWorkflowConnection(DownloadRuntime dr, String user, String pass, String requestMethod, boolean useXMLHeader) throws IOException, MalformedURLException {
        String url = dr.getUrl();
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setInstanceFollowRedirects(false);
        String userCredentials = String.valueOf(user) + ":" + pass;
        new Base64();
        String basicAuth = "Basic " + new String(Base64.encode((byte[])userCredentials.getBytes()));
        con.setRequestProperty("Authorization", basicAuth);
        if (useXMLHeader) {
            con.setRequestProperty("Content-Type", "application/xml");
            con.setRequestProperty("Accept", "application/xml");
        }
        con.setRequestMethod(requestMethod);
        return con;
    }

    private static String findNextStep(String responseContent) {
        XMLMemento m;
        if (responseContent != null && !responseContent.isEmpty() && (m = XMLMemento.createReadRoot((InputStream)new ByteArrayInputStream(responseContent.getBytes()))) != null) {
            IMemento workflow = m.getChild("workflow");
            IMemento step = workflow.getChild("step");
            String nextStep = ((XMLMemento)step).getTextData();
            return nextStep;
        }
        return null;
    }

    public static String getWorkflowResponseContent(DownloadRuntime dr, String userS, String passS) throws IOException {
        String line;
        int nRead;
        HttpURLConnection con = DownloadManagerWorkflowUtility.getWorkflowConnection(dr, userS, passS, "GET", true);
        InputStream stream = con.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] bytes = buffer.toByteArray();
        con.disconnect();
        String result = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
        while ((line = br.readLine()) != null) {
            result = String.valueOf(result) + line;
        }
        br.close();
        String nextStep = DownloadManagerWorkflowUtility.findNextStep(result);
        if (nextStep == null) {
            result = "";
            br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(bytes))));
            while ((line = br.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            br.close();
        }
        return result;
    }

    public static WizardFragment getNextWorkflowFragment(String response) {
        String nextStep = DownloadManagerWorkflowUtility.findNextStep(response);
        if ("termsAndConditions".equals(nextStep)) {
            return new DownloadManagerTermsAndConditionsFragment();
        }
        return null;
    }
}

