/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimePathEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;

    public RuntimePathEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        switch (column) {
            case 0: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                this.editor = new CheckboxCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            }
        }
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        return this.column != 0;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        RuntimePath runtimePath = (RuntimePath)element;
        String value = null;
        switch (this.column) {
            case 0: {
                value = runtimePath.getPath();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 1: {
                boolean scan = runtimePath.isScanOnEveryStartup();
                return scan;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        RuntimePath runtimePath = (RuntimePath)element;
        switch (this.column) {
            case 0: {
                if (value != null) {
                    runtimePath.setPath(value.toString());
                } else {
                    runtimePath.setPath(null);
                }
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().setSelection(null);
                this.getViewer().setSelection(selection);
                break;
            }
            case 1: {
                runtimePath.setScanOnEveryStartup(((Boolean)value).booleanValue());
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

