/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence.GenericClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernatePackageInfo;
import org.jboss.tools.hibernate.jpt.core.internal.context.persistence.PackageInfoRef;

public class HibernateClassRef
extends GenericClassRef
implements PackageInfoRef {
    protected HibernatePackageInfo javaPackageInfo;

    public HibernateClassRef(PersistenceUnit parent, XmlJavaClassRef xmlJavaClassRef) {
        super(parent, xmlJavaClassRef);
        JavaResourcePackage resourcePackage = this.resolveJavaResourcePackage();
        if (resourcePackage != null) {
            this.javaPackageInfo = this.buildJavaPackageInfo(resourcePackage);
        }
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    protected boolean isInPackage(IPackageFragment packageFragment) {
        return super.isInPackage(packageFragment);
    }

    protected String getPackageName() {
        return super.getPackageName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        if (this.javaPackageInfo != null) {
            this.javaPackageInfo.synchronizeWithResourceModel();
        }
    }

    public void update() {
        super.update();
        this.updateJavaPackageInfo();
    }

    @Override
    public HibernatePackageInfo getJavaPackageInfo() {
        return this.javaPackageInfo;
    }

    protected void setJavaPackageInfo(HibernatePackageInfo javaPackageInfo) {
        HibernatePackageInfo old = this.javaPackageInfo;
        this.javaPackageInfo = javaPackageInfo;
        this.firePropertyChanged("javaPackageInfo", old, javaPackageInfo);
    }

    protected void updateJavaPackageInfo() {
        JavaResourcePackage resourcePackage = this.resolveJavaResourcePackage();
        if (resourcePackage == null) {
            if (this.javaPackageInfo != null) {
                this.setJavaPackageInfo(null);
            }
        } else if (this.javaPackageInfo == null) {
            this.setJavaPackageInfo(this.buildJavaPackageInfo(resourcePackage));
        } else if (this.javaPackageInfo.getResourcePackage() == resourcePackage) {
            this.javaPackageInfo.update();
        } else {
            this.setJavaPackageInfo(this.buildJavaPackageInfo(resourcePackage));
        }
    }

    protected String getJavaPackageInfoName() {
        return this.getClassName();
    }

    protected JavaResourcePackage resolveJavaResourcePackage() {
        String javaPackageInfoName = this.getJavaPackageInfoName();
        return javaPackageInfoName == null ? null : this.getJpaProject().getJavaResourcePackage(javaPackageInfoName);
    }

    protected HibernatePackageInfo buildJavaPackageInfo(JavaResourcePackage jrpt) {
        return this.getJpaFactory().buildJavaPackageInfo(this, jrpt);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (StringTools.isBlank((String)this.className)) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.PERSISTENCE_UNIT_UNSPECIFIED_CLASS, new Object[]{this.getValidationTextRange()}));
            return;
        }
        if (this.getJavaPersistentType() == null && this.javaPackageInfo == null) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.PERSISTENCE_UNIT_NONEXISTENT_CLASS, new Object[]{new String[]{this.getJavaClassName()}, this.getValidationTextRange()}));
            return;
        }
        if (this.getJavaPersistentType() != null) {
            boolean validateJavaPersistentType = true;
            for (MappingFileRef mappingFileRef : this.getPersistenceUnit().getMappingFileRefsContaining(this.getJavaClassName())) {
                validateJavaPersistentType = false;
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.PERSISTENCE_UNIT_REDUNDANT_CLASS, new Object[]{new String[]{this.getJavaClassName(), mappingFileRef.getFileName()}, this.getValidationTextRange()}));
            }
            if (validateJavaPersistentType) {
                this.validateJavaManagedType(messages, reporter);
            }
        } else {
            this.validatePackageInfo(messages, reporter);
        }
    }

    protected void validatePackageInfo(List<IMessage> messages, IReporter reporter) {
        try {
            this.javaPackageInfo.validate(messages, reporter);
        }
        catch (Throwable t) {
            HibernateJptPlugin.logException(t);
        }
    }
}

