/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaParameter;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;

public class HibernateJavaParameter
extends AbstractJavaContextModel<JpaContextModel>
implements JavaParameter {
    protected String name;
    protected String value;
    protected ParameterAnnotation resourceParameter;

    public HibernateJavaParameter(JpaContextModel parent, ParameterAnnotation resourceParameter) {
        super(parent);
        this.resourceParameter = resourceParameter;
        this.name = resourceParameter.getName();
        this.value = resourceParameter.getValue();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.resourceParameter.getName());
        this.setValue_(this.resourceParameter.getValue());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.resourceParameter.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.resourceParameter.setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    public TextRange getValidationTextRange() {
        return this.resourceParameter.getTextRange();
    }

    @Override
    public ParameterAnnotation getParameterAnnotation() {
        return this.resourceParameter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

