/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaMappingRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaManyToManyMapping;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKey;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKeyHolder;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaManyToManyRelationship;

public class HibernateJavaManyToManyMapping
extends AbstractJavaManyToManyMapping
implements ForeignKeyHolder {
    protected ForeignKey foreignKey = this.buildForeignKey();

    public HibernateJavaManyToManyMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    protected JavaMappingRelationship buildRelationship() {
        return new HibernateJavaManyToManyRelationship((JavaManyToManyMapping)this);
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncForeignKey();
    }

    public void update() {
        super.update();
        if (this.foreignKey != null) {
            this.foreignKey.update();
        }
    }

    protected void syncForeignKey() {
        ForeignKeyAnnotation annotation = this.getForeignKeyAnnotation();
        if (annotation == null) {
            if (this.getForeignKey() != null) {
                this.setForeignKey(null);
            }
        } else if (this.getForeignKey() == null) {
            this.setForeignKey(this.buildForeignKey(annotation));
        } else if (this.foreignKey != null && this.foreignKey.getForeignKeyAnnotation() == annotation) {
            this.foreignKey.synchronizeWithResourceModel();
        } else {
            this.setForeignKey(this.buildForeignKey(annotation));
        }
    }

    @Override
    public ForeignKey addForeignKey() {
        if (this.getForeignKey() != null) {
            throw new IllegalStateException("foreignKey already exists");
        }
        ForeignKeyAnnotation annotation = (ForeignKeyAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.ForeignKey");
        ForeignKey foreignKey = this.buildForeignKey(annotation);
        this.setForeignKey(foreignKey);
        return this.foreignKey;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    protected void setForeignKey(ForeignKey newForeignKey) {
        ForeignKey oldForeignKey = this.foreignKey;
        this.foreignKey = newForeignKey;
        this.firePropertyChanged("foreignKey", oldForeignKey, newForeignKey);
    }

    @Override
    public void removeForeignKey() {
        if (this.getForeignKey() == null) {
            throw new IllegalStateException("foreignKey does not exist, cannot be removed");
        }
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.ForeignKey");
        this.setForeignKey(null);
    }

    protected ForeignKey buildForeignKey() {
        ForeignKeyAnnotation annotation = this.getForeignKeyAnnotation();
        return annotation == null ? null : this.buildForeignKey(annotation);
    }

    protected ForeignKey buildForeignKey(ForeignKeyAnnotation annotation) {
        return this.getJpaFactory().buildForeignKey(this, annotation);
    }

    protected ForeignKeyAnnotation getForeignKeyAnnotation() {
        return (ForeignKeyAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.ForeignKey");
    }

    @Override
    public Table getForeignKeyDbTable() {
        return this.getTypeMapping().getPrimaryDbTable();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateForeignKey(messages, reporter);
    }

    protected void validateForeignKey(List<IMessage> messages, IReporter reporter) {
        if (this.foreignKey != null) {
            this.foreignKey.validate(messages, reporter);
        }
    }
}

