/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.UIMessages;

public class AddGeneratedClassesJob
extends WorkspaceJob {
    private JpaProject jpaProject;
    private List<IResource> javaFilesToAdd;

    public AddGeneratedClassesJob(JpaProject jpaProject, List<IResource> javaFilesToAdd) {
        super(UIMessages.SYNC_CLASSES_JOB);
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        this.setRule(ruleFactory.modifyRule((IResource)jpaProject.getProject()));
        this.jpaProject = jpaProject;
        this.javaFilesToAdd = javaFilesToAdd;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        XmlPersistenceUnit persistenceUnit;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)UIMessages.SYNC_CLASSES_TASK, (int)20);
        JptXmlResource resource = this.jpaProject.getPersistenceXmlResource();
        if (resource == null) {
            return Status.OK_STATUS;
        }
        if (sm.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        sm.worked(1);
        XmlPersistence persistence = (XmlPersistence)resource.getRootObject();
        if (persistence.getPersistenceUnits().size() > 0) {
            persistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
        } else {
            persistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
            persistenceUnit.setName(this.jpaProject.getName());
            persistence.getPersistenceUnits().add((Object)persistenceUnit);
        }
        sm.worked(1);
        IStatus status = this.addNewClassRefs((IProgressMonitor)sm.newChild(17), this.jpaProject, persistenceUnit);
        resource.save();
        sm.done();
        return status;
    }

    protected IStatus addNewClassRefs(IProgressMonitor monitor, JpaProject jpaProject, XmlPersistenceUnit persistenceUnit) {
        Iterable<String> mappedClassNames = this.getMappedNewClassNames(jpaProject, '$');
        for (String str : mappedClassNames) {
            System.out.println(str);
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)IterableTools.size(mappedClassNames));
        for (String fullyQualifiedTypeName : mappedClassNames) {
            if (!this.mappingFileContains(jpaProject, fullyQualifiedTypeName)) {
                XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
                classRef.setJavaClass(fullyQualifiedTypeName);
                persistenceUnit.getClasses().add((Object)classRef);
            }
            if (sm.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            sm.worked(1);
        }
        return Status.OK_STATUS;
    }

    protected Iterable<String> getMappedNewClassNames(final JpaProject jpaProject, final char enclosingTypeSeparator) {
        return new TransformationIterable((Iterable)new FilteringIterable((Iterable)new TransformationIterable(jpaProject.getTypeMappingAnnotationNames(), (Transformer)new Transformer<String, IType>(){

            public IType transform(String fullyQualifiedName) {
                return AddGeneratedClassesJob.this.findType(jpaProject, fullyQualifiedName);
            }
        }), (Predicate)new Predicate<IType>(){

            public boolean evaluate(IType mapping) {
                if (mapping != null) {
                    for (IResource res : AddGeneratedClassesJob.this.javaFilesToAdd) {
                        if (!res.equals((Object)mapping.getResource())) continue;
                        return true;
                    }
                }
                return false;
            }
        }), (Transformer)new Transformer<IType, String>(){

            public String transform(IType jdtType) {
                return jdtType.getFullyQualifiedName(enclosingTypeSeparator);
            }
        });
    }

    protected IType findType(JpaProject jpaProject, String typeName) {
        try {
            return jpaProject.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    boolean mappingFileContains(JpaProject jpaProject, String fullyQualifiedTypeName) {
        PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return false;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return false;
        }
        if (persistence.getPersistenceUnitsSize() == 0) {
            return false;
        }
        PersistenceUnit persistenceUnit = persistence.getPersistenceUnit(0);
        for (MappingFileRef mappingFileRef : persistenceUnit.getMappingFileRefs()) {
            if (mappingFileRef.getPersistentType(fullyQualifiedTypeName) == null) continue;
            return true;
        }
        return false;
    }
}

