/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.hibernate.console.ConnectionProfileUtil;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.nature.HibernateNature;
import org.hibernate.eclipse.utils.HibernateEclipseUtils;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.runtime.spi.IService;

public class JPAPostInstallFasetListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.POST_INSTALL) {
            String platformId;
            IProject project = event.getProject().getProject();
            IProjectFacetActionEvent pEvent = (IProjectFacetActionEvent)event;
            if (pEvent.getProjectFacet().getId().equals("jpt.jpa") && (platformId = HibernateEclipseUtils.getJpaPlatformID((IProject)project)) != null && (platformId.equals("hibernate") || platformId.equals("hibernate2_0") || platformId.equals("hibernate2_1")) && this.checkPreConditions(project)) {
                this.exportConnectionProfilePropertiesToPersistenceXml(project);
                this.buildConsoleConfiguration(project, platformId);
            }
        }
    }

    private void exportConnectionProfilePropertiesToPersistenceXml(IProject project) {
        XmlPersistenceUnit persistenceUnit;
        PersistenceXmlResourceProvider defaultXmlResourceProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
        JptXmlResource resource = defaultXmlResourceProvider.getXmlResource();
        Properties propsToAdd = this.getConnectionProperties(project);
        if (propsToAdd.isEmpty() || resource == null) {
            return;
        }
        XmlPersistence persistence = (XmlPersistence)resource.getRootObject();
        if (persistence.getPersistenceUnits().size() > 0 && (persistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0)).getProperties() == null) {
            persistenceUnit.setProperties(PersistenceFactory.eINSTANCE.createXmlProperties());
            for (Map.Entry<Object, Object> entry : propsToAdd.entrySet()) {
                XmlProperty prop = PersistenceFactory.eINSTANCE.createXmlProperty();
                prop.setName((String)entry.getKey());
                prop.setValue((String)entry.getValue());
                persistenceUnit.getProperties().getProperties().add((Object)prop);
            }
        }
        resource.save();
    }

    public Properties getConnectionProperties(IProject project) {
        String cpName;
        ConsoleConfiguration cc;
        HibernateNature hibNat;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IService service = null;
        if (javaProject != null && (hibNat = HibernateNature.getHibernateNature((IJavaProject)javaProject)) != null && (cc = hibNat.getDefaultConsoleConfiguration()) != null) {
            service = cc.getHibernateExtension().getHibernateService();
        }
        if ((cpName = HibernateEclipseUtils.getConnectionProfileName((IProject)project)) != null && service != null) {
            return ConnectionProfileUtil.getHibernateConnectionProperties(service, (IConnectionProfile)ProfileManager.getInstance().getProfileByName(cpName));
        }
        return new Properties();
    }

    protected boolean checkPreConditions(IProject project) {
        try {
            ILaunchConfiguration lc = this.getLaunchConfiguration(project);
            if (lc != null && lc.exists()) {
                ProjectUtils.toggleHibernateOnProject((IProject)project, (boolean)true, (String)lc.getName());
                return false;
            }
        }
        catch (CoreException e) {
            HibernateJptPlugin.logException(e);
        }
        return true;
    }

    private ILaunchConfiguration getLaunchConfiguration(IProject project) throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] lcs = LaunchHelper.findHibernateLaunchConfigs();
        int i = 0;
        while (i < lcs.length) {
            ILaunchConfiguration lc = lcs[i];
            if (project.getName().equals(lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null))) {
                if (project.getName().equals(lc.getName())) {
                    return lc;
                }
                configs.add(lc);
            }
            ++i;
        }
        Pattern p = Pattern.compile(String.valueOf(project.getName()) + " \\(\\d+\\)");
        int i2 = 0;
        while (i2 < configs.size()) {
            ILaunchConfiguration lc = (ILaunchConfiguration)configs.get(i2);
            if (p.matcher(lc.getName()).matches()) {
                return lc;
            }
            ++i2;
        }
        return configs.size() > 0 ? (ILaunchConfiguration)configs.get(0) : null;
    }

    protected void buildConsoleConfiguration(IProject project, String platformId) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType lct = LaunchHelper.getHibernateLaunchConfigsType();
        String launchName = lm.generateLaunchConfigurationName(project.getName());
        try {
            ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, launchName);
            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Collections.singletonList(new Path(project.getName()).makeAbsolute().toString()));
            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Collections.singletonList(Integer.toString(4)));
            wc.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.JPA.toString());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            wc.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", null);
            wc.setAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.toString(true));
            if ("hibernate2_1".equals(platformId)) {
                wc.setAttribute("org.hibernate.eclipse.launch.HIBERNATE_VERSION", "4.3");
                wc.setAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", this.getPersistenceUnitName(project));
            } else if ("hibernate2_0".equals(platformId)) {
                wc.setAttribute("org.hibernate.eclipse.launch.HIBERNATE_VERSION", "4.0");
            } else {
                wc.setAttribute("org.hibernate.eclipse.launch.HIBERNATE_VERSION", "3.6");
            }
            wc.doSave();
            ProjectUtils.toggleHibernateOnProject((IProject)project, (boolean)true, (String)launchName);
        }
        catch (CoreException e) {
            HibernateJptPlugin.logException(e);
        }
    }

    private String getPersistenceUnitName(IProject project) {
        String result = null;
        PersistenceXmlResourceProvider defaultXmlResourceProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
        JptXmlResource resource = defaultXmlResourceProvider.getXmlResource();
        XmlPersistence persistence = (XmlPersistence)resource.getRootObject();
        if (persistence.getPersistenceUnits().size() > 0) {
            XmlPersistenceUnit persistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
            result = persistenceUnit.getName();
        }
        return result;
    }
}

