/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core;

import java.io.File;
import tern.ITernProject;
import tern.eclipse.ide.core.ITernServerFactory;
import tern.eclipse.ide.server.nodejs.internal.core.preferences.TernNodejsCorePreferencesSupport;
import tern.server.ITernServer;
import tern.server.nodejs.NodejsTernServer;

public class TernNodejsServerFactory
implements ITernServerFactory {
    public ITernServer create(ITernProject project) throws Exception {
        File installPath = this.getInstallPath();
        File ternFile = project.getRepository().getTernBaseDir();
        NodejsTernServer server = this.isRemoteAccess() ? new NodejsTernServer(project, this.getRemotePort()) : new NodejsTernServer(project, installPath, ternFile);
        server.setTimeout(this.getTimeout());
        server.setTestNumber(this.getTestNumber());
        server.setPersistent(this.isPersistent());
        return server;
    }

    private boolean isRemoteAccess() {
        return TernNodejsCorePreferencesSupport.getInstance().isNodejsRemoteAccess();
    }

    private int getRemotePort() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsRemotePort();
    }

    private File getInstallPath() {
        return TernNodejsCorePreferencesSupport.getInstance().getInstallPath();
    }

    private long getTimeout() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsTimeout();
    }

    private int getTestNumber() {
        return TernNodejsCorePreferencesSupport.getInstance().getNodejsTestNumber();
    }

    private boolean isPersistent() {
        return TernNodejsCorePreferencesSupport.getInstance().isNodejsPersistent();
    }
}

