/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.runtime.spi.IJDBCReader;
import org.jboss.tools.hibernate.runtime.spi.IMetaDataDialect;
import org.jboss.tools.hibernate.runtime.spi.IProgressListener;

public abstract class AbstractJDBCReaderFacade
extends AbstractFacade
implements IJDBCReader {
    private IMetaDataDialect metaDataDialect = null;

    public AbstractJDBCReaderFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public IMetaDataDialect getMetaDataDialect() {
        Object targetMetaDataDialect;
        if (this.metaDataDialect == null && (targetMetaDataDialect = Util.invokeMethod(this.getTarget(), "getMetaDataDialect", new Class[0], new Object[0])) != null) {
            this.metaDataDialect = this.getFacadeFactory().createMetaDataDialect(targetMetaDataDialect);
        }
        return this.metaDataDialect;
    }

    public void readDatabaseSchema(IDatabaseCollector databaseCollector, String defaultCatalogName, String defaultSchemaName, IProgressListener progressListener) {
        Object databaseCollectorTarget = Util.invokeMethod(databaseCollector, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "readDatabaseSchema", new Class[]{this.getDatabaseCollectorClass(), String.class, String.class, this.getProgressListenerClass()}, new Object[]{databaseCollectorTarget, defaultCatalogName, defaultSchemaName, this.createProgressListener(progressListener)});
    }

    public Class<?> getProgressListenerClass() {
        return Util.getClass(this.getProgressListenerClassName(), this.getFacadeFactoryClassLoader());
    }

    public Class<?> getDatabaseCollectorClass() {
        return Util.getClass(this.getDatabaseCollectorClassName(), this.getFacadeFactoryClassLoader());
    }

    public String getProgressListenerClassName() {
        return "org.hibernate.cfg.reveng.ProgressListener";
    }

    public String getDatabaseCollectorClassName() {
        return "org.hibernate.cfg.reveng.DatabaseCollector";
    }

    private Object createProgressListener(IProgressListener progressListener) {
        return Proxy.newProxyInstance(this.getFacadeFactoryClassLoader(), new Class[]{this.getProgressListenerClass()}, (InvocationHandler)new ProgressListenerInvocationHandler(progressListener));
    }

    private class ProgressListenerInvocationHandler
    implements InvocationHandler {
        public Object target;

        public ProgressListenerInvocationHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("startSubTask".equals(method.getName())) {
                Util.invokeMethod(this.target, "startSubTask", new Class[]{String.class}, args);
            }
            return null;
        }
    }
}

