/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IForeignKey;
import org.jboss.tools.hibernate.runtime.spi.ITable;

public abstract class AbstractForeignKeyFacade
extends AbstractFacade
implements IForeignKey {
    protected ITable referencedTable = null;
    protected HashSet<IColumn> columns = null;
    protected List<IColumn> referencedColumns = null;

    public AbstractForeignKeyFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public ITable getReferencedTable() {
        Object targetReferencedTable = Util.invokeMethod(this.getTarget(), "getReferencedTable", new Class[0], new Object[0]);
        if (this.referencedTable == null && targetReferencedTable != null) {
            this.referencedTable = this.getFacadeFactory().createTable(targetReferencedTable);
        }
        return this.referencedTable;
    }

    public Iterator<IColumn> columnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    public boolean isReferenceToPrimaryKey() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isReferenceToPrimaryKey", new Class[0], new Object[0]);
    }

    public List<IColumn> getReferencedColumns() {
        if (this.referencedColumns == null) {
            this.initializeReferencedColumns();
        }
        return this.referencedColumns;
    }

    public boolean containsColumn(IColumn column) {
        Object columnTarget = Util.invokeMethod(column, "getTarget", new Class[0], new Object[0]);
        return (Boolean)Util.invokeMethod(this.getTarget(), "containsColumn", new Class[]{this.getColumnClass()}, new Object[]{columnTarget});
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.getColumnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getColumnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected void initializeColumns() {
        this.columns = new HashSet();
        Iterator origin = (Iterator)Util.invokeMethod(this.getTarget(), "columnIterator", new Class[0], new Object[0]);
        while (origin.hasNext()) {
            this.columns.add(this.getFacadeFactory().createColumn(origin.next()));
        }
    }

    protected void initializeReferencedColumns() {
        this.referencedColumns = new ArrayList<IColumn>();
        List targetReferencedColumns = (List)Util.invokeMethod(this.getTarget(), "getReferencedColumns", new Class[0], new Object[0]);
        for (Object column : targetReferencedColumns) {
            this.referencedColumns.add(this.getFacadeFactory().createColumn(column));
        }
    }
}

