/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.ArrayList;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.HibernateException;
import org.jboss.tools.hibernate.runtime.spi.IClassMetadata;
import org.jboss.tools.hibernate.runtime.spi.IEntityMetamodel;
import org.jboss.tools.hibernate.runtime.spi.ISession;
import org.jboss.tools.hibernate.runtime.spi.IType;

public abstract class AbstractClassMetadataFacade
extends AbstractFacade
implements IClassMetadata {
    protected IType[] propertyTypes = null;
    protected IType identifierType = null;

    public AbstractClassMetadataFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public Class<?> getMappedClass() {
        return (Class)Util.invokeMethod(this.getTarget(), "getMappedClass", new Class[0], new Object[0]);
    }

    public Object getPropertyValue(Object object, String name) throws HibernateException {
        try {
            return Util.invokeMethod(this.getTarget(), "getPropertyValue", new Class[]{Object.class, String.class}, new Object[]{object, name});
        }
        catch (Throwable t) {
            throw new HibernateException(t.getMessage(), t.getCause());
        }
    }

    public String getEntityName() {
        return (String)Util.invokeMethod(this.getTarget(), "getEntityName", new Class[0], new Object[0]);
    }

    public String getIdentifierPropertyName() {
        return (String)Util.invokeMethod(this.getTarget(), "getIdentifierPropertyName", new Class[0], new Object[0]);
    }

    public String[] getPropertyNames() {
        return (String[])Util.invokeMethod(this.getTarget(), "getPropertyNames", new Class[0], new Object[0]);
    }

    public IType[] getPropertyTypes() {
        if (this.propertyTypes == null) {
            this.initializePropertyTypes();
        }
        return this.propertyTypes;
    }

    public IType getIdentifierType() {
        if (this.identifierType == null) {
            this.identifierType = this.getFacadeFactory().createType(Util.invokeMethod(this.getTarget(), "getIdentifierType", new Class[0], new Object[0]));
        }
        return this.identifierType;
    }

    public boolean isInstanceOfAbstractEntityPersister() {
        return this.getAbstractEntityPersisterClass().isAssignableFrom(this.getTarget().getClass());
    }

    public IEntityMetamodel getEntityMetamodel() {
        Object entityMetamodel = Util.invokeMethod(this.getTarget(), "getEntityMetamodel", new Class[0], new Object[0]);
        return entityMetamodel != null ? this.getFacadeFactory().createEntityMetamodel(entityMetamodel) : null;
    }

    public Object getIdentifier(Object object, ISession session) {
        Object sessionImplementor = Util.invokeMethod(session, "getTarget", new Class[0], new Object[0]);
        return Util.invokeMethod(this.getTarget(), "getIdentifier", new Class[]{Object.class, this.getSessionImplementorClass()}, new Object[]{object, sessionImplementor});
    }

    public boolean hasIdentifierProperty() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "hasIdentifierProperty", new Class[0], new Object[0]);
    }

    protected Class<?> getSessionImplementorClass() {
        return Util.getClass(this.getSessionImplementorClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getSessionImplementorClassName() {
        return "org.hibernate.engine.spi.SessionImplementor";
    }

    protected Class<?> getAbstractEntityPersisterClass() {
        return Util.getClass(this.getAbstractEntityPersisterClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getAbstractEntityPersisterClassName() {
        return "org.hibernate.persister.entity.AbstractEntityPersister";
    }

    protected void initializePropertyTypes() {
        Object[] originTypes = (Object[])Util.invokeMethod(this.getTarget(), "getPropertyTypes", new Class[0], new Object[0]);
        ArrayList<IType> propertyTypes = new ArrayList<IType>(originTypes.length);
        Object[] objectArray = originTypes;
        int n = originTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object type = objectArray[n2];
            propertyTypes.add(this.getFacadeFactory().createType(type));
            ++n2;
        }
        this.propertyTypes = propertyTypes.toArray(new IType[originTypes.length]);
    }
}

