/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.core.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.core.resources.VTaskListenerImpl;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class CommonValidator
implements IValidatorJob {
    private static Set<IProject> validatingProjects = new HashSet<IProject>();

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        XModel model;
        IWorkbenchContext validationHelper = (IWorkbenchContext)helper;
        IProject project = validationHelper.getProject();
        String[] uris = validationHelper.getURIs();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (project == null && uris != null && uris.length != 0) {
            String[] stringArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                IProject f = root.getProject(new Path(s).segment(0));
                if (f != null && f.exists()) {
                    project = f;
                    break;
                }
                ++n2;
            }
        }
        if (project == null) {
            return OK_STATUS;
        }
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)project);
        XModel xModel = model = n == null ? null : n.getModel();
        if (model == null || VHelper.getManager() == null) {
            return OK_STATUS;
        }
        VModel vmodel = VModelFactory.getModel(model);
        if (vmodel == null) {
            return OK_STATUS;
        }
        if (uris == null || uris.length == 0) {
            XModelObject object = FileSystemsHelper.getWebInf((XModel)model);
            if (object == null) {
                return OK_STATUS;
            }
            VObject vobject = vmodel.getObjectByPath(object.getPath());
            VRule[] rules = VHelper.getRules(VHelper.getManager(), vobject);
            if (rules == null) {
                return OK_STATUS;
            }
            VTask task = VHelper.getManager().createTask(vobject);
            VTaskListenerImpl listener = new VTaskListenerImpl();
            listener.setModel(model);
            listener.setTask(task);
            listener.setSignificance(VHelper.getManager().getMinSignificance());
            task.addTaskListener(listener);
            task.run();
            task.removeTaskListener(listener);
            return OK_STATUS;
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        String[] listener = uris;
        int n3 = uris.length;
        int rules = 0;
        while (rules < n3) {
            String uri = listener[rules];
            IFile f = root.getFile((IPath)new Path(uri));
            if (f != null && f.exists() && f.getProject() == project) {
                files.add(f);
            }
            ++rules;
        }
        if (files.isEmpty()) {
            return OK_STATUS;
        }
        IStatus status = OK_STATUS;
        for (IFile file : files) {
            VRule[] rules2;
            VObject vobject;
            XModelObject object = EclipseResourceUtil.getObjectByResource((IResource)file);
            if (object == null || (vobject = vmodel.getObjectByPath(object.getPath())) == null || (rules2 = VHelper.getRules(VHelper.getManager(), vobject)) == null) continue;
            VTask task = VHelper.getManager().createTask(vobject);
            VTaskListenerImpl listener2 = new VTaskListenerImpl();
            listener2.setModel(model);
            listener2.setTask(task);
            listener2.setSignificance(VHelper.getManager().getMinSignificance());
            task.addTaskListener(listener2);
            task.run();
            task.removeTaskListener(listener2);
        }
        return status;
    }

    public void cleanup(IReporter reporter) {
        reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

