/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.server.nodejs.core.IDENodejsProcessHelper;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.FileComboFieldEditor;
import tern.eclipse.ide.ui.ImageResource;
import tern.utils.StringUtils;

public class TernNodejsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button remoteAccessButton;
    private IntegerFieldEditor remotePortField;
    private Button directAccessButton;
    private IntegerFieldEditor timeoutField;
    private IntegerFieldEditor testNumberField;
    private BooleanFieldEditor persistentField;
    private ComboFieldEditor nodeJSInstallField;
    private Label nodePathTitle;
    private FileComboFieldEditor nativeNodePath;
    private Text nodePath;

    public TernNodejsPreferencesPage() {
        super(1);
        this.setDescription(TernNodejsUIMessages.TernNodejsPreferencesPage_desc);
        this.setImageDescriptor(ImageResource.getImageDescriptor((String)"logo"));
    }

    protected void createFieldEditors() {
        boolean isRemote = this.getPreferenceStore().getBoolean("nodejsRemoteAccess");
        this.createRemoteAccessContent(this.getFieldEditorParent(), isRemote);
        this.createSeparator(this.getFieldEditorParent());
        this.createDirectAccessContent(this.getFieldEditorParent(), !isRemote);
        this.updateEnabled(isRemote);
    }

    private void createRemoteAccessContent(Composite parent, boolean isRemote) {
        this.remoteAccessButton = this.addRadioButton(parent, TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSRemoteAccess, isRemote);
        this.remoteAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernNodejsPreferencesPage.this.updateEnabled(true);
            }
        });
        this.remotePortField = new IntegerFieldEditor("nodejsRemotePort", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSRemotePort, parent);
        this.addField((FieldEditor)this.remotePortField);
    }

    private void createDirectAccessContent(final Composite parent, boolean isDirect) {
        this.directAccessButton = this.addRadioButton(parent, TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSDirectAccess, isDirect);
        this.directAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernNodejsPreferencesPage.this.updateEnabled(false);
            }
        });
        this.timeoutField = new IntegerFieldEditor("nodeJSTimeout", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTimeout, parent);
        this.addField((FieldEditor)this.timeoutField);
        this.testNumberField = new IntegerFieldEditor("nodeJSTestNumber", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTestNumber, parent);
        this.addField((FieldEditor)this.testNumberField);
        this.persistentField = new BooleanFieldEditor("nodeJSPersistent", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPersistent, parent);
        this.addField((FieldEditor)this.persistentField);
        INodejsInstall[] installs = TernNodejsCorePlugin.getNodejsInstallManager().getNodejsInstalls();
        String[][] data = new String[installs.length + 1][2];
        data[0][0] = TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall_emptyValue;
        data[0][1] = "";
        int i = 0;
        while (i < installs.length) {
            data[i + 1][0] = installs[i].getName();
            data[i + 1][1] = installs[i].getId();
            ++i;
        }
        this.nodeJSInstallField = new ComboFieldEditor("nodeJSInstall", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall, data, parent){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                INodejsInstall install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(newValue.toString());
                if (install == null || install.isNative()) {
                    TernNodejsPreferencesPage.this.nativeNodePath.setEnabled(true, parent);
                    String defaultPath = IDENodejsProcessHelper.getNodejsPath();
                    TernNodejsPreferencesPage.this.nativeNodePath.setStringValue(defaultPath);
                    TernNodejsPreferencesPage.this.nodePath.setText(defaultPath);
                } else {
                    TernNodejsPreferencesPage.this.nativeNodePath.setEnabled(false, parent);
                    TernNodejsPreferencesPage.this.nodePath.setText(install.getPath().getAbsolutePath());
                }
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
        this.addField((FieldEditor)this.nodeJSInstallField);
        String[] defaultPaths = IDENodejsProcessHelper.getDefaultNodejsPaths();
        this.nativeNodePath = new FileComboFieldEditor("nodeJSPath", TernNodejsUIMessages.TernNodejsPreferencesPage_nativeNodeJSPath, defaultPaths, parent){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                TernNodejsPreferencesPage.this.nodePath.setText(newValue.toString());
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
        this.addField(this.nativeNodePath);
        this.nodePathTitle = new Label(parent, 0);
        this.nodePathTitle.setText(TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPath);
        GridData gridData = new GridData(2);
        this.nodePathTitle.setLayoutData((Object)gridData);
        this.nodePath = new Text(parent, 72);
        this.nodePath.setText("");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.nodePath.setLayoutData((Object)gridData);
    }

    public void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        separator.setLayoutData((Object)gd);
    }

    private Button addRadioButton(Composite parent, String label, boolean selected) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setLayoutData((Object)gd);
        button.setSelection(selected);
        return button;
    }

    private void updateEnabled(boolean isRemote) {
        Composite parent = this.getFieldEditorParent();
        this.remotePortField.setEnabled(isRemote, parent);
        this.timeoutField.setEnabled(!isRemote, parent);
        this.testNumberField.setEnabled(!isRemote, parent);
        this.persistentField.setEnabled(!isRemote, parent);
        this.nodeJSInstallField.setEnabled(!isRemote, parent);
        this.nodePathTitle.setEnabled(!isRemote);
        this.nativeNodePath.setEnabled(!isRemote, parent);
        this.nodePath.setEnabled(!isRemote);
    }

    protected void initialize() {
        super.initialize();
        boolean isRemote = this.getPreferenceStore().getBoolean("nodejsRemoteAccess");
        this.updateNodePath(false, isRemote);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        InstanceScope scope = new InstanceScope();
        return new ScopedPreferenceStore((IScopeContext)scope, "tern.eclipse.ide.server.nodejs.core");
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("nodejsRemoteAccess", this.remoteAccessButton.getSelection());
        TernCorePlugin.getTernServerTypeManager().fireServerPreferencesChanged(null);
        return result;
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean isRemote = this.getPreferenceStore().getDefaultBoolean("nodejsRemoteAccess");
        this.updateNodePath(true, isRemote);
        this.remoteAccessButton.setSelection(isRemote);
        this.directAccessButton.setSelection(!isRemote);
        this.updateEnabled(isRemote);
    }

    public void updateNodePath(boolean defaultValue, boolean isRemote) {
        INodejsInstall install = this.getNodejsInstall(defaultValue);
        if (install != null) {
            if (install.isNative()) {
                this.nodePath.setText(this.nativeNodePath.getStringValue());
            } else {
                this.nodePath.setText(install.getPath().getAbsolutePath());
            }
        }
        this.nativeNodePath.setEnabled(!isRemote && install != null && install.isNative(), this.getFieldEditorParent());
    }

    private INodejsInstall getNodejsInstall(boolean defaultValue) {
        String installId;
        INodejsInstall install = null;
        String string = installId = defaultValue ? super.getPreferenceStore().getDefaultString("nodeJSInstall") : super.getPreferenceStore().getString("nodeJSInstall");
        if (!StringUtils.isEmpty((String)installId)) {
            install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(installId);
        }
        return install;
    }
}

