/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontManager {
    public static final String AESH_CONSOLE_FONT = "org.jboss.tools.aesh.ui.font";
    public static FontManager INSTANCE = new FontManager();
    private static Font ITALIC;
    private static Font DEFAULT;
    private static Font BOLD;
    private static Font ITALIC_BOLD;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();

    private FontManager() {
        this.initializeFonts();
        this.initializeListener();
    }

    private void initializeDefault() {
        DEFAULT = JFaceResources.getFont((String)AESH_CONSOLE_FONT);
    }

    private FontData createFontDataFromNormal() {
        FontData normalData = DEFAULT.getFontData()[0];
        FontData result = new FontData();
        result.setName(normalData.getName());
        result.height = normalData.height;
        return result;
    }

    private void initializeItalic() {
        FontData italicData = this.createFontDataFromNormal();
        italicData.setStyle(2);
        ITALIC = new Font(DEFAULT.getDevice(), italicData);
    }

    private void initializeBold() {
        FontData boldData = this.createFontDataFromNormal();
        boldData.setStyle(1);
        BOLD = new Font(DEFAULT.getDevice(), boldData);
    }

    private void initializeItalicBold() {
        FontData italicBoldData = this.createFontDataFromNormal();
        italicBoldData.setStyle(3);
        ITALIC_BOLD = new Font(DEFAULT.getDevice(), italicBoldData);
    }

    public Font getDefault() {
        return DEFAULT;
    }

    public Font getItalic() {
        return ITALIC;
    }

    public Font getBold() {
        return BOLD;
    }

    public Font getItalicBold() {
        return ITALIC_BOLD;
    }

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void initializeListener() {
        JFaceResources.getFontRegistry().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (FontManager.AESH_CONSOLE_FONT.equals(event.getProperty())) {
                    FontManager.this.initializeFonts();
                    FontManager.this.informListeners(event);
                }
            }
        });
    }

    private void informListeners(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    private void initializeFonts() {
        this.initializeDefault();
        this.initializeBold();
        this.initializeItalic();
        this.initializeItalicBold();
    }
}

