/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.ui.internal.document;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.jboss.tools.aesh.core.document.Style;
import org.jboss.tools.aesh.ui.internal.util.ColorConstants;
import org.jboss.tools.aesh.ui.internal.util.FontManager;

public class StyleImpl
implements Style {
    StyleRange styleRange;
    boolean imageNegative = false;

    public StyleImpl(StyleRange styleRange) {
        this.styleRange = styleRange;
    }

    public StyleRange getStyleRange() {
        return this.styleRange;
    }

    public void resetToNormal() {
        this.styleRange.font = FontManager.INSTANCE.getDefault();
        this.styleRange.foreground = ColorConstants.BLACK;
        this.styleRange.background = ColorConstants.WHITE;
    }

    public void setBoldOn() {
        if (FontManager.INSTANCE.getDefault() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getBold();
        } else if (FontManager.INSTANCE.getItalic() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getItalicBold();
        }
    }

    public void setFaintOn() {
    }

    public void setItalicOn() {
        if (FontManager.INSTANCE.getDefault() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getItalic();
        } else if (FontManager.INSTANCE.getBold() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getItalicBold();
        }
    }

    public void setUnderlineSingle() {
        this.styleRange.underline = true;
        this.styleRange.underlineStyle = 4;
    }

    public void setImageNegative() {
        if (!this.imageNegative) {
            this.reverseVideo();
        }
    }

    public void setCrossedOut() {
        this.styleRange.strikeout = true;
    }

    public void setBoldOrFaintOff() {
        if (FontManager.INSTANCE.getBold() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getDefault();
        } else if (FontManager.INSTANCE.getItalicBold() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getItalic();
        }
    }

    public void setItalicOff() {
        if (FontManager.INSTANCE.getItalic() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getDefault();
        } else if (FontManager.INSTANCE.getItalicBold() == this.styleRange.font) {
            this.styleRange.font = FontManager.INSTANCE.getBold();
        }
    }

    public void setUnderlineNone() {
        this.styleRange.underline = false;
        this.styleRange.underlineStyle = 0;
    }

    public void setImagePositive() {
        if (this.imageNegative) {
            this.reverseVideo();
        }
    }

    public void setNotCrossedOut() {
        this.styleRange.strikeout = false;
    }

    public void setForegroundBlack() {
        this.styleRange.foreground = ColorConstants.BLACK;
    }

    public void setForegroundRed() {
        this.styleRange.foreground = ColorConstants.RED;
    }

    public void setForegroundGreen() {
        this.styleRange.foreground = ColorConstants.GREEN;
    }

    public void setForegroundYellow() {
        this.styleRange.foreground = ColorConstants.YELLOW;
    }

    public void setForegroundBlue() {
        this.styleRange.foreground = ColorConstants.BLUE;
    }

    public void setForegroundMagenta() {
        this.styleRange.foreground = ColorConstants.MAGENTA;
    }

    public void setForegroundCyan() {
        this.styleRange.foreground = ColorConstants.CYAN;
    }

    public void setForegroundWhite() {
        this.styleRange.foreground = ColorConstants.WHITE;
    }

    public void setForegroundXTerm(int colour) {
    }

    public void setForegroundDefault() {
        this.styleRange.foreground = ColorConstants.DEFAULT_FOREGROUND;
    }

    public void setBackgroundBlack() {
        this.styleRange.background = ColorConstants.BLACK;
    }

    public void setBackgroundRed() {
        this.styleRange.background = ColorConstants.RED;
    }

    public void setBackgroundGreen() {
        this.styleRange.background = ColorConstants.GREEN;
    }

    public void setBackgroundYellow() {
        this.styleRange.background = ColorConstants.YELLOW;
    }

    public void setBackgroundBlue() {
        this.styleRange.background = ColorConstants.BLUE;
    }

    public void setBackgroundMagenta() {
        this.styleRange.background = ColorConstants.MAGENTA;
    }

    public void setBackgroundCyan() {
        this.styleRange.background = ColorConstants.CYAN;
    }

    public void setBackgroundWhite() {
        this.styleRange.background = ColorConstants.WHITE;
    }

    public void setBackgroundXTerm(int colour) {
    }

    public void setBackgroundDefault() {
        this.styleRange.background = ColorConstants.DEFAULT_BACKGROUND;
    }

    public void setLength(int length) {
        this.styleRange.length = length;
    }

    public int getLength() {
        return this.styleRange.length;
    }

    public int getStart() {
        return this.styleRange.start;
    }

    private void reverseVideo() {
        Color foreground = this.styleRange.foreground;
        Color background = this.styleRange.background;
        this.styleRange.background = foreground;
        this.styleRange.foreground = background;
        this.imageNegative = !this.imageNegative;
    }

    public static StyleImpl getDefault() {
        Font font = FontManager.INSTANCE.getDefault();
        Color foreground = ColorConstants.BLACK;
        Color background = ColorConstants.WHITE;
        TextStyle textStyle = new TextStyle(font, foreground, background);
        StyleRange styleRange = new StyleRange(textStyle);
        return new StyleImpl(styleRange);
    }
}

