/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.internal.core.validation.SeamProjectPropertyValidator;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.wizard.SeamBaseWizardPage;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

public class SeamEntityWizardPage1
extends SeamBaseWizardPage {
    public SeamEntityWizardPage1(IStructuredSelection is) {
        super("seam.new.entity.page1", "Seam Entity", null, is);
        this.setMessage(this.getDefaultMessageText());
    }

    @Override
    protected void createEditors() {
        this.rootSeamProject = SeamWizardUtils.getRootSeamProject((ISelection)this.initialSelection);
        String selectedProject = this.rootSeamProject == null ? "" : this.rootSeamProject.getName();
        this.addEditor(SeamWizardFactory.createSeamProjectSelectionFieldEditor(selectedProject));
        this.addEditor(SeamWizardFactory.createSeamEntityClasNameFieldEditor());
        String packageName = this.getDefaultPackageName(selectedProject);
        this.addEditor(SeamWizardFactory.createSeamJavaPackageSelectionFieldEditor(packageName));
        this.addEditor(SeamWizardFactory.createSeamMasterPageNameFieldEditor());
        this.addEditor(SeamWizardFactory.createSeamPageNameFieldEditor());
        this.setSeamProjectNameData(selectedProject);
    }

    @Override
    public void createControl(Composite parent) {
        this.setControl((Control)new SeamBaseWizardPage.GridLayoutComposite(this, parent));
        this.setPageComplete(false);
        if ("".equals(((IFieldEditor)this.editorRegistry.get("seam.project.name")).getValue()) && this.getEditor("seam.package.name") != null) {
            this.getEditor("seam.package.name").setEnabled(false);
        }
    }

    @Override
    public void doFillDefaults(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("entity.name")) {
            if (event.getNewValue() == null || "".equals(event.getNewValue().toString().trim())) {
                this.setDefaultValue("entity.name", "");
                this.setDefaultValue("masterPage.name", "");
                this.setDefaultValue("page.name", "");
            } else {
                String value = event.getNewValue().toString();
                String valueL = String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1);
                this.setDefaultValue("masterPage.name", String.valueOf(valueL) + "List");
                this.setDefaultValue("page.name", valueL);
            }
        }
        if (event.getPropertyName().equals("seam.project.name")) {
            String selectedProject = event.getNewValue().toString();
            this.setSeamProjectNameData(selectedProject);
            this.setDefaultValue("seam.package.name", this.getDefaultPackageName(selectedProject));
        }
    }

    @Override
    protected String getDefaultPackageName(IEclipsePreferences seamFacetPrefs) {
        return seamFacetPrefs.get("model.package", "");
    }

    @Override
    protected boolean isProjectSettingsOk() {
        if (this.rootSeamProject != null) {
            IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)this.rootSeamProject);
            return SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("model.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("action.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("seam.project.web.root.folder", ""), (boolean)false) && ("false".equals(prefs.get("seam.test.creating", "false").trim()) || SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("test.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isProjectNameValid((String)prefs.get("seam.test.project", ""), (boolean)false)) && ("war".equals(prefs.get("seam.project.deployment.type", "war").trim()) || SeamProjectPropertyValidator.isProjectNameValid((String)prefs.get("seam.ejb.project", ""), (boolean)false));
        }
        return true;
    }

    @Override
    protected void doValidate(PropertyChangeEvent event) {
        IProject project;
        if (!this.isValidProjectSelected()) {
            return;
        }
        IFieldEditor packageEditor = this.getEditor("seam.package.name");
        if (packageEditor != null) {
            packageEditor.setEnabled(true);
        }
        if (!this.isValidRuntimeConfigured(project = this.getSelectedProject())) {
            return;
        }
        Map errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate(((IFieldEditor)this.editorRegistry.get("entity.name")).getValue(), null);
        if (!errors.isEmpty()) {
            this.setErrorMessage(NLS.bind((String)((IStatus)errors.get("default.error")).getMessage(), (Object)SeamCoreMessages.SEAM_ENTITY_WIZARD_PAGE1_ENTITY_CLASS_NAME));
            this.setPageComplete(false);
            return;
        }
        IFieldEditor editor = (IFieldEditor)this.editorRegistry.get("seam.package.name");
        if (editor != null && !(errors = SeamValidatorFactory.PACKAGE_NAME_VALIDATOR.validate(editor.getValue(), null)).isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.FILE_NAME_VALIDATOR.validate(((IFieldEditor)this.editorRegistry.get("masterPage.name")).getValue(), (Object)new Object[]{SeamCoreMessages.SEAM_ENTITY_WIZARD_PAGE1_ENTITY_MASTER_PAGE, project, project});
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.FILE_NAME_VALIDATOR.validate(((IFieldEditor)this.editorRegistry.get("page.name")).getValue(), (Object)new Object[]{SeamCoreMessages.SEAM_ENTITY_WIZARD_PAGE1_PAGE, project});
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                IType component = javaProject.findType(String.valueOf((String)((IFieldEditor)this.editorRegistry.get("seam.package.name")).getValue()) + "." + ((IFieldEditor)this.editorRegistry.get("entity.name")).getValue());
                if (component != null) {
                    this.setErrorMessage(null);
                    this.setMessage(SeamCoreMessages.ENTITY_CLASS_ALREADY_EXISTS, 2);
                    this.setPageComplete(true);
                    return;
                }
            }
            catch (JavaModelException ex) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
        SeamProjectsSet seamPrjSet = new SeamProjectsSet(project);
        IPath webContent = seamPrjSet.getViewsFolder().getFullPath();
        IPath masterPage = webContent.append(((IFieldEditor)this.editorRegistry.get("masterPage.name")).getValue() + ".xhtml");
        IFile masterPageFile = ResourcesPlugin.getWorkspace().getRoot().getFile(masterPage);
        if (masterPageFile.exists()) {
            this.setErrorMessage(null);
            this.setMessage(SeamCoreMessages.MASTER_PAGE_ALREADY_EXISTS, 2);
            this.setPageComplete(true);
            return;
        }
        IPath page = webContent.append(((IFieldEditor)this.editorRegistry.get("page.name")).getValue() + ".xhtml");
        IFile pageFile = ResourcesPlugin.getWorkspace().getRoot().getFile(page);
        if (pageFile.exists()) {
            this.setErrorMessage(null);
            this.setMessage(SeamCoreMessages.PAGE_ALREADY_EXISTS, 2);
            this.setPageComplete(true);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(this.getDefaultMessageText());
        this.setPageComplete(true);
    }

    @Override
    public String getDefaultMessageText() {
        return "Create a new Entity";
    }
}

