/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamProjectChangeListener;
import org.jboss.tools.seam.ui.views.AbstractSeamContentProvider;

public class RootContentProvider
extends AbstractSeamContentProvider {
    IWorkspaceRoot root;

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            IProject[] ps = root.getProjects();
            ArrayList<IProject> children = new ArrayList<IProject>();
            int i = 0;
            while (i < ps.length) {
                ISeamProject p;
                if (ps[i].isAccessible() && (p = SeamCorePlugin.getSeamProject((IProject)ps[i], (boolean)false)) != null) {
                    if (!this.processed.contains(p)) {
                        this.processed.add(p);
                        p.addSeamProjectListener((ISeamProjectChangeListener)this);
                    }
                    children.add(p.getProject());
                }
                ++i;
            }
            return children.toArray(new IProject[0]);
        }
        if (parentElement instanceof IProject) {
            ISeamProject p = SeamCorePlugin.getSeamProject((IProject)((IProject)parentElement), (boolean)false);
            if (p != null) {
                return super.getChildren(p);
            }
            return new Object[0];
        }
        return super.getChildren(parentElement);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof ISeamProject || element instanceof IProject) {
            return this.root;
        }
        Object o = super.getParent(element);
        if (o instanceof ISeamProject) {
            return ((ISeamProject)o).getProject();
        }
        return o;
    }

    @Override
    protected void handlePreDelete(IResource resource) {
        if (resource instanceof IProject && this.viewer != null) {
            final IProject p = (IProject)resource;
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RootContentProvider.this.viewer != null) {
                        RootContentProvider.this.viewer.remove((Object)p);
                    }
                }
            });
        }
    }

    @Override
    protected void handleProjectAdded(IProject project) {
        this.refresh();
    }

    @Override
    protected void handleProjectInfoChanged(IProject project) {
        this.refresh();
    }

    @Override
    protected Object getTreeObject(Object source) {
        if (source instanceof ISeamProject) {
            return ((ISeamProject)source).getProject();
        }
        return source;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof IWorkspaceRoot || newInput == null) {
            this.root = (IWorkspaceRoot)newInput;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.root = null;
    }
}

