/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.wizards.TableFilterView;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;
import org.jboss.tools.seam.ui.views.DBTablesViewer;

public abstract class DBTableFilterView
extends TableFilterView {
    private DBTablesViewer viewer;

    public DBTableFilterView(Composite parent, int style) {
        super(parent, style);
    }

    protected TreeViewer createTreeViewer() {
        if (this.viewer == null) {
            this.viewer = new DBTablesViewer(this.tree);
        }
        return this.viewer;
    }

    protected void doRefreshTree() {
        ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
        if (configuration != null) {
            this.viewer.setInput(configuration);
        }
    }

    protected void toggle(boolean exclude) {
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object sel : ss) {
                DBTablesViewer.Element tc;
                ITableFilter filter = null;
                if (sel instanceof Table) {
                    Table table = (Table)sel;
                    filter = this.revEngDef.createTableFilter();
                    if (StringHelper.isNotEmpty((String)table.getName())) {
                        filter.setMatchName(table.getName());
                    }
                    if (StringHelper.isNotEmpty((String)table.getCatalog())) {
                        filter.setMatchCatalog(table.getCatalog());
                    }
                    if (StringHelper.isNotEmpty((String)table.getSchema())) {
                        filter.setMatchSchema(table.getSchema());
                    }
                    filter.setExclude(Boolean.valueOf(exclude));
                } else if (sel instanceof DBTablesViewer.Schema) {
                    tc = (DBTablesViewer.Schema)sel;
                    filter = this.revEngDef.createTableFilter();
                    String schema = tc.getName();
                    String catalog = ((DBTablesViewer.Schema)tc).getParent().getName();
                    if (StringHelper.isNotEmpty((String)schema)) {
                        filter.setMatchSchema(schema);
                    }
                    if (StringHelper.isNotEmpty((String)catalog)) {
                        filter.setMatchCatalog(catalog);
                    }
                    filter.setExclude(Boolean.valueOf(exclude));
                } else if (sel instanceof DBTablesViewer.Catalog) {
                    tc = (DBTablesViewer.Catalog)sel;
                    filter = this.revEngDef.createTableFilter();
                    if (StringHelper.isNotEmpty((String)tc.getName())) {
                        filter.setMatchCatalog(tc.getName());
                    }
                    filter.setExclude(Boolean.valueOf(exclude));
                }
                if (filter == null) continue;
                this.revEngDef.addTableFilter(filter);
            }
        } else {
            ITableFilter filter = this.revEngDef.createTableFilter();
            filter.setExclude(Boolean.valueOf(exclude));
            this.revEngDef.addTableFilter(filter);
        }
    }
}

