/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.text.java.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.java.ASTVisitorImpl;
import org.jboss.tools.seam.internal.core.scanner.java.AnnotatedASTNode;
import org.jboss.tools.seam.internal.core.scanner.java.ResolvedAnnotation;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public class JavaAnnotationScanner {
    Map<ResolvedAnnotation, AnnotatedASTNode<ASTNode>> resolvedAnnotations = null;
    IType resolvedType = null;

    public void parse(ICompilationUnit u) throws ScannerException {
        this.resolvedAnnotations = null;
        this.resolvedType = null;
        if (u == null) {
            return;
        }
        ASTRequestorImpl requestor = new ASTRequestorImpl(u);
        ICompilationUnit[] us = new ICompilationUnit[]{u};
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(u);
        p.setResolveBindings(true);
        p.createASTs(us, new String[0], (ASTRequestor)requestor, null);
        this.resolvedType = requestor.getType();
        this.resolvedAnnotations = requestor.getAnnotations();
    }

    public Map<ResolvedAnnotation, AnnotatedASTNode<ASTNode>> getResolvedAnnotations() {
        return this.resolvedAnnotations;
    }

    public IType getResolvedType() {
        return this.resolvedType;
    }

    private ICompilationUnit getCompilationUnit(IFile f) throws CoreException {
        IProject project = f.getProject();
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IResource[] rs = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        int i = 0;
        while (i < rs.length) {
            IPath path;
            IJavaElement e;
            if (rs[i].getFullPath().isPrefixOf(f.getFullPath()) && (e = javaProject.findElement(path = f.getFullPath().removeFirstSegments(rs[i].getFullPath().segmentCount()))) instanceof ICompilationUnit) {
                return (ICompilationUnit)e;
            }
            ++i;
        }
        return null;
    }

    public ResolvedAnnotation findAnnotationByValueOffset(int offset) {
        if (this.resolvedAnnotations == null) {
            return null;
        }
        for (ResolvedAnnotation a : this.resolvedAnnotations.keySet()) {
            NormalAnnotation na;
            Object vpd;
            if (a.getAnnotation() instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation sma = (SingleMemberAnnotation)a.getAnnotation();
                vpd = sma.getStructuralProperty((StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY);
                if (!(vpd instanceof ASTNode)) continue;
                ASTNode node = (ASTNode)vpd;
                int start = node.getStartPosition();
                int length = node.getLength();
                if (offset < start || offset >= start + length) continue;
                return a;
            }
            if (!(a.getAnnotation() instanceof NormalAnnotation) || !((vpd = (na = (NormalAnnotation)a.getAnnotation()).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY)) instanceof List)) continue;
            for (Object item : (List)vpd) {
                MemberValuePair mvp;
                SimpleName name;
                ASTNode node;
                if (!(item instanceof ASTNode) || (node = (ASTNode)item).getNodeType() != 80 || !"value".equals((name = (mvp = (MemberValuePair)node).getName()).getIdentifier())) continue;
                int start = node.getStartPosition();
                int length = node.getLength();
                if (offset < start || offset >= start + length) continue;
                return a;
            }
        }
        return null;
    }

    public String getAnnotationValue(ResolvedAnnotation annotation) {
        NormalAnnotation na;
        Object vpd;
        if (annotation.getAnnotation() instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation sma = (SingleMemberAnnotation)annotation.getAnnotation();
            Object vpd2 = sma.getStructuralProperty((StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY);
            if (vpd2 instanceof StringLiteral) {
                return ((StringLiteral)vpd2).getLiteralValue();
            }
            return vpd2.toString();
        }
        if (annotation.getAnnotation() instanceof NormalAnnotation && (vpd = (na = (NormalAnnotation)annotation.getAnnotation()).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY)) instanceof List) {
            for (Object item : (List)vpd) {
                MemberValuePair mvp;
                SimpleName name;
                ASTNode node;
                if (!(item instanceof ASTNode) || (node = (ASTNode)item).getNodeType() != 80 || !"value".equals((name = (mvp = (MemberValuePair)node).getName()).getIdentifier())) continue;
                return ((StringLiteral)mvp.getValue()).getLiteralValue();
            }
        }
        return null;
    }

    public IRegion getAnnotationValueRegion(ResolvedAnnotation annotation) {
        NormalAnnotation na;
        Object vpd;
        if (annotation.getAnnotation() instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation sma = (SingleMemberAnnotation)annotation.getAnnotation();
            Object vpd2 = sma.getStructuralProperty((StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY);
            if (vpd2 instanceof StringLiteral) {
                StringLiteral sl = (StringLiteral)vpd2;
                return new Region(sl.getStartPosition() + 1, sl.getLength());
            }
            if (vpd2 instanceof ASTNode) {
                ASTNode astNode = (ASTNode)vpd2;
                return new Region(astNode.getStartPosition(), astNode.getLength());
            }
            return null;
        }
        if (annotation.getAnnotation() instanceof NormalAnnotation && (vpd = (na = (NormalAnnotation)annotation.getAnnotation()).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY)) instanceof List) {
            for (Object item : (List)vpd) {
                MemberValuePair mvp;
                SimpleName name;
                ASTNode node;
                if (!(item instanceof ASTNode) || (node = (ASTNode)item).getNodeType() != 80 || !"value".equals((name = (mvp = (MemberValuePair)node).getName()).getIdentifier())) continue;
                Object sValuesObj = mvp.getStructuralProperty((StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY);
                if (sValuesObj instanceof StringLiteral) {
                    StringLiteral sl = (StringLiteral)sValuesObj;
                    return new Region(sl.getStartPosition() + 1, sl.getLength());
                }
                if (sValuesObj instanceof ASTNode) {
                    ASTNode astNode = (ASTNode)sValuesObj;
                    return new Region(astNode.getStartPosition(), astNode.getLength());
                }
                return null;
            }
        }
        return null;
    }

    public boolean isAnnotationOfType(ResolvedAnnotation annotation, String typeName) {
        if (annotation == null || typeName == null) {
            return false;
        }
        return typeName.equals(annotation.getType());
    }

    static String getResolvedType(IType type, String n) {
        try {
            String[][] rs = type.resolveType(n);
            if (rs != null && rs.length > 0) {
                return rs[0][0].length() == 0 ? rs[0][1] : String.valueOf(rs[0][0]) + "." + rs[0][1];
            }
        }
        catch (JavaModelException e) {
            SeamGuiPlugin.getDefault().logError(e);
        }
        return n;
    }

    class ASTRequestorImpl
    extends ASTRequestor {
        private ASTVisitorImpl visitor = new ASTVisitorImpl();
        List<ResolvedAnnotation> annotations = new ArrayList<ResolvedAnnotation>();
        IResource resource;
        IPath sourcePath;
        ICompilationUnit unit;
        IType type = null;
        AnnotatedASTNode<AbstractTypeDeclaration> annotatedType = null;
        Set<AnnotatedASTNode<FieldDeclaration>> annotatedFields = null;
        Set<AnnotatedASTNode<MethodDeclaration>> annotatedMethods = null;
        Map<ResolvedAnnotation, AnnotatedASTNode<ASTNode>> annotationMap = new HashMap<ResolvedAnnotation, AnnotatedASTNode<ASTNode>>();

        public ASTRequestorImpl(IResource resource) {
            this.resource = resource;
            this.sourcePath = resource.getFullPath();
        }

        public ASTRequestorImpl(ICompilationUnit unit) {
            this.unit = unit;
            this.resource = unit.getResource();
            this.sourcePath = this.resource.getFullPath();
        }

        public Map<ResolvedAnnotation, AnnotatedASTNode<ASTNode>> getAnnotations() {
            return this.annotationMap;
        }

        public IType getType() {
            return this.type;
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            IType[] ts = null;
            try {
                ts = source.getTypes();
            }
            catch (JavaModelException e) {
                SeamGuiPlugin.getDefault().logError(e);
            }
            if (ts == null || ts.length == 0) {
                return;
            }
            int i = 0;
            while (i < ts.length) {
                block8: {
                    this.visitor.setType(null);
                    int f = 0;
                    try {
                        f = ts[i].getFlags();
                    }
                    catch (JavaModelException javaModelException) {
                        break block8;
                    }
                    if (Flags.isPublic((int)f)) {
                        this.visitor.setType(ts[i]);
                        ast.accept((ASTVisitor)this.visitor);
                        if (this.visitor.hasSeamComponent()) {
                            this.processTypeData(this.visitor.root);
                        }
                    }
                }
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processTypeData(ASTVisitorImpl.TypeData data) {
            int i;
            void var3_4;
            this.type = data.type;
            this.annotatedType = data.annotatedType;
            this.annotatedFields = data.annotatedFields;
            this.annotatedMethods = data.annotatedMethods;
            ResolvedAnnotation[] annotations = this.annotatedType.getAnnotations();
            boolean bl = false;
            while (annotations != null && var3_4 < annotations.length) {
                this.annotationMap.put(annotations[var3_4], this.annotatedType);
                ++var3_4;
            }
            if (this.annotatedMethods != null) {
                for (AnnotatedASTNode<MethodDeclaration> annotatedASTNode : this.annotatedMethods) {
                    annotations = annotatedASTNode.getAnnotations();
                    i = 0;
                    while (annotations != null && i < annotations.length) {
                        this.annotationMap.put(annotations[i], annotatedASTNode);
                        ++i;
                    }
                }
            }
            if (this.annotatedFields != null) {
                for (AnnotatedASTNode<MethodDeclaration> annotatedASTNode : this.annotatedFields) {
                    annotations = annotatedASTNode.getAnnotations();
                    i = 0;
                    while (annotations != null && i < annotations.length) {
                        this.annotationMap.put(annotations[i], annotatedASTNode);
                        ++i;
                    }
                }
            }
        }
    }
}

