/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.preferences.SettingsPage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.preferences.SeamPreferencesMessages;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SeamSettingsPreferencePage
extends SettingsPage {
    public static final String ID = "org.jboss.tools.seam.ui.propertyPages.SeamSettingsPreferencePage";
    private IProject project;
    private IProject warProject;
    private IEclipsePreferences preferences;
    private ISeamProject warSeamProject;
    private SeamProjectsSet seamProjectSet;
    private boolean suportSeam;
    private boolean runtimeIsSelected;
    private List<Group> groups = new ArrayList<Group>();
    private boolean warning;
    private boolean error;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        this.setWarProject(SeamWizardUtils.getRootSeamProject(this.project));
    }

    private void setWarProject(IProject warProject) {
        this.warProject = warProject;
        if (warProject != null) {
            this.preferences = SeamCorePlugin.getSeamPreferences((IProject)warProject);
            this.warSeamProject = SeamCorePlugin.getSeamProject((IProject)warProject, (boolean)false);
        } else {
            this.preferences = SeamCorePlugin.getSeamPreferences((IProject)this.project);
        }
        this.seamProjectSet = new SeamProjectsSet(this.getSeamProject());
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout(1, false);
        root.setLayout((Layout)gridLayout);
        Composite generalGroup = new Composite(root, 0);
        generalGroup.setLayoutData((Object)gd);
        gridLayout = new GridLayout(4, false);
        generalGroup.setLayout((Layout)gridLayout);
        IFieldEditor seamSupportCheckBox = IFieldEditorFactory.INSTANCE.createCheckboxEditor(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT, this.warSeamProject != null);
        seamSupportCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (value instanceof Boolean) {
                    boolean v = (Boolean)value;
                    SeamSettingsPreferencePage.this.setEnabledSeamSuport(v);
                }
            }
        });
        this.suportSeam = this.warSeamProject != null;
        this.registerEditor(seamSupportCheckBox, generalGroup);
        IFieldEditor seamRuntimeEditor = SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(this.getSeamVersions(), this.getSeamRuntimeName(), true);
        seamRuntimeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                SeamSettingsPreferencePage.this.setRuntimeIsSelected(value.toString().length() > 0);
            }
        });
        this.registerEditor(seamRuntimeEditor, generalGroup);
        IFieldEditor projectNameEditor = SeamWizardFactory.createSeamProjectSelectionFieldEditor("seam.project.name", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_SEAM_PROJECT, this.getPrefValue("seam.project.name", this.getSeamProjectName()), false, false);
        projectNameEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IProject project = SeamSettingsPreferencePage.this.getMainProjectFromField();
                if (project != null) {
                    SeamSettingsPreferencePage.this.setWarProject(project);
                }
            }
        });
        this.registerEditor(projectNameEditor, generalGroup);
        Group deploymentGroup = this.createGroup(root, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_DEPLOYMENT, 4);
        ITaggedFieldEditor deployTypeEditor = IFieldEditorFactory.INSTANCE.createRadioEditor("seam.project.deployment.type", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_DEPLOY_TYPE, Arrays.asList("war".toUpperCase(), "ear".toUpperCase()), Arrays.asList("war", "ear"), this.getDeployAsValue());
        deployTypeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SeamSettingsPreferencePage.this.setEnabledDeploymentGroup();
            }
        });
        this.registerEditor((IFieldEditor)deployTypeEditor, (Composite)deploymentGroup);
        IFieldEditor ejbProjectEditor = SeamWizardFactory.createSeamProjectSelectionFieldEditor("seam.ejb.project", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_EJB_PROJECT, this.getEjbProjectName(), true, false);
        this.registerEditor(ejbProjectEditor, (Composite)deploymentGroup);
        Group viewGroup = this.createGroup(root, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_VIEW, 3);
        IFieldEditor viewFolderEditor = SeamWizardFactory.createViewFolderFieldEditor(this.getViewFolder());
        this.registerEditor(viewFolderEditor, (Composite)viewGroup);
        Group modelGroup = this.createGroup(root, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_MODEL, 3);
        String sourceFolder = this.getModelSourceFolder();
        IFieldEditor modelSourceFolderEditor = IFieldEditorFactory.INSTANCE.createBrowseSourceFolderEditor("model.sources", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_SOURCE_FOLDER, sourceFolder);
        final IFieldEditor modelPackageEditor = IFieldEditorFactory.INSTANCE.createBrowsePackageEditor("model.package", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_PACKAGE, sourceFolder != null ? sourceFolder : "", this.getModelPackageName());
        modelSourceFolderEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                modelPackageEditor.setData((Object)"source.folder.path", (Object)SeamSettingsPreferencePage.this.getValue("model.sources"));
            }
        });
        this.registerEditor(modelSourceFolderEditor, (Composite)modelGroup);
        this.registerEditor(modelPackageEditor, (Composite)modelGroup);
        Group actionGroup = this.createGroup(root, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_ACTION, 3);
        sourceFolder = this.getActionSourceFolder();
        IFieldEditor actionSourceFolderEditor = IFieldEditorFactory.INSTANCE.createBrowseSourceFolderEditor("action.sources", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_SOURCE_FOLDER, sourceFolder);
        final IFieldEditor actionPackageEditor = IFieldEditorFactory.INSTANCE.createBrowsePackageEditor("action.package", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_PACKAGE, sourceFolder != null ? sourceFolder : "", this.getActionPackageName());
        actionSourceFolderEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                actionPackageEditor.setData((Object)"source.folder.path", (Object)SeamSettingsPreferencePage.this.getValue("action.sources"));
            }
        });
        this.registerEditor(actionSourceFolderEditor, (Composite)actionGroup);
        this.registerEditor(actionPackageEditor, (Composite)actionGroup);
        Group testGroup = this.createGroup(root, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_TEST, 3);
        IFieldEditor createTestCheckBox = IFieldEditorFactory.INSTANCE.createCheckboxEditor("seam.test.creating", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_CREATE_TEST, this.shouldCreateTests());
        createTestCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (value instanceof Boolean) {
                    SeamSettingsPreferencePage.this.setEnabledTestGroup();
                }
            }
        });
        this.registerEditor(createTestCheckBox, (Composite)testGroup);
        IFieldEditor testProjectEditor = SeamWizardFactory.createSeamProjectSelectionFieldEditor("seam.test.project", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_PROJECT, this.getTestProjectName(), false, false);
        this.registerEditor(testProjectEditor, (Composite)testGroup);
        sourceFolder = this.getTestSourceFolder();
        IFieldEditor testSourceFolderEditor = IFieldEditorFactory.INSTANCE.createBrowseSourceFolderEditor("test.sources", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_SOURCE_FOLDER, sourceFolder);
        final IFieldEditor testPackageEditor = IFieldEditorFactory.INSTANCE.createBrowsePackageEditor("test.package", SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCES_PAGE_PACKAGE, sourceFolder != null ? sourceFolder : "", this.getTestPackageName());
        testSourceFolderEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                testPackageEditor.setData((Object)"source.folder.path", (Object)SeamSettingsPreferencePage.this.getValue("test.sources"));
            }
        });
        this.registerEditor(testSourceFolderEditor, (Composite)testGroup);
        this.registerEditor(testPackageEditor, (Composite)testGroup);
        this.setRuntimeIsSelected(this.getSeamRuntimeName().length() > 0);
        this.setEnabledSeamSuport(this.isSeamSupported());
        this.validate();
        return root;
    }

    private IProject getMainProjectFromField() {
        String name = this.getValue("seam.project.name").trim();
        if (name.length() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project != null && project.exists()) {
            return project;
        }
        return null;
    }

    private boolean shouldCreateTests() {
        String value = this.getPrefValue("seam.test.creating", "false");
        return Boolean.parseBoolean(value);
    }

    private String getPrefValue(String prefName, String defaultValue) {
        return this.preferences.get(prefName, defaultValue);
    }

    private Group createGroup(Composite parent, String title, int rows) {
        return this.createGroupWithSpan(parent, title, rows, 1);
    }

    private Group createGroupWithSpan(Composite parent, String title, int rows, int span) {
        GridData gd = new GridData(2);
        gd.horizontalSpan = span;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        Group newGroup = new Group(parent, 0);
        newGroup.setLayoutData((Object)gd);
        newGroup.setText(title);
        GridLayout gridLayout = new GridLayout(rows, false);
        newGroup.setLayout((Layout)gridLayout);
        this.groups.add(newGroup);
        return newGroup;
    }

    private String getModelSourceFolder() {
        String folder = null;
        if (this.preferences != null) {
            folder = this.preferences.get("model.sources", null);
        }
        if (folder == null) {
            folder = this.getDefaultModelSourceFolder();
        }
        return folder;
    }

    private String getDefaultModelSourceFolder() {
        IContainer f = this.seamProjectSet.getDefaultModelFolder();
        return f != null ? f.getFullPath().toString() : this.getDefaultSrcFolder();
    }

    private String getModelPackageName() {
        String name = null;
        if (this.preferences != null) {
            name = this.preferences.get("model.package", null);
        }
        if (name == null) {
            name = this.getDefaultModelPackageName();
        }
        return name;
    }

    private String getDefaultModelPackageName() {
        return "org.domain." + SeamUtil.getSeamPackageName((String)this.getSeamProjectName()) + ".entity";
    }

    private String getActionPackageName() {
        String name = null;
        if (this.preferences != null) {
            name = this.preferences.get("action.package", null);
        }
        if (name == null) {
            name = this.getDefaultActionPackageName();
        }
        return name;
    }

    private String getDefaultActionPackageName() {
        return "org.domain." + SeamUtil.getSeamPackageName((String)this.getSeamProjectName()) + ".session";
    }

    private String getTestPackageName() {
        String name = null;
        if (this.preferences != null) {
            name = this.preferences.get("test.package", null);
        }
        if (name == null) {
            name = this.getDefaultTestPackageName();
        }
        return name;
    }

    private String getDefaultTestPackageName() {
        return "org.domain." + SeamUtil.getSeamPackageName((String)this.getSeamProject().getName()) + ".test";
    }

    private String getActionSourceFolder() {
        String folder = null;
        if (this.preferences != null) {
            folder = this.preferences.get("action.sources", null);
        }
        if (folder == null) {
            folder = this.getDefaultActionSourceFolder();
        }
        return folder;
    }

    private String getDefaultActionSourceFolder() {
        IContainer f = this.seamProjectSet.getDefaultActionFolder();
        return f != null ? f.getFullPath().toString() : this.getDefaultSrcFolder();
    }

    private String getDefaultSrcFolder() {
        IResource resource = EclipseResourceUtil.getJavaSourceRoot((IProject)this.project);
        if (resource != null) {
            return ((IContainer)resource).getFullPath().toString();
        }
        return this.project.getFullPath().toString();
    }

    private String getTestSourceFolder() {
        String folder = null;
        if (this.preferences != null) {
            folder = this.preferences.get("test.sources", null);
        }
        if (folder == null) {
            folder = this.getDefaultTestSourceFolder();
        }
        return folder;
    }

    private String getDefaultTestSourceFolder() {
        IContainer f = this.seamProjectSet.getDefaultTestSourceFolder();
        return f != null ? f.getFullPath().toString() : this.getDefaultSrcFolder();
    }

    private String getViewFolder() {
        String folder = null;
        if (this.preferences != null) {
            folder = this.preferences.get("seam.project.web.root.folder", null);
        }
        if (folder == null) {
            folder = this.getDefaultViewFolder();
        }
        return folder;
    }

    private String getDefaultViewFolder() {
        IVirtualFolder webRootFolder;
        IContainer f = this.seamProjectSet.getDefaultViewsFolder();
        if (f != null) {
            return f.getFullPath().toString();
        }
        IVirtualComponent com = ComponentCore.createComponent((IProject)this.project);
        if (com != null && (webRootFolder = com.getRootFolder().getFolder((IPath)new Path("/"))) != null) {
            return webRootFolder.getUnderlyingFolder().getFullPath().toString();
        }
        return this.project.getFullPath().toString();
    }

    private List<String> getProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    private String getEjbProjectName() {
        if (this.preferences != null) {
            return this.preferences.get("seam.ejb.project", this.project.getName());
        }
        return this.project.getName();
    }

    private Object getDeployAsValue() {
        if (this.preferences != null) {
            return this.preferences.get("seam.project.deployment.type", "war");
        }
        return this.seamProjectSet.getDefaultDeployType();
    }

    protected void validate() {
        String viewFolder;
        SeamVersion installedVersion;
        this.warning = false;
        this.error = false;
        if (!this.isSeamSupported()) {
            this.setValid(true);
            this.setErrorMessage(null);
            this.setMessage(null, 2);
            return;
        }
        if (!this.runtimeIsSelected) {
            this.setMessage(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_RUNTIME_IS_NOT_SELECTED, 2);
            this.setValid(true);
            this.setErrorMessage(null);
            return;
        }
        String value = this.getValue("seam.runtime.name");
        SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(value);
        if (seamRuntime == null) {
            this.setErrorMessage(NLS.bind((String)SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_RUNTIME_DOES_NOT_EXIST, (Object[])new String[]{value}));
            this.setValid(false);
            return;
        }
        Map errors = SeamValidatorFactory.SEAM_RUNTIME_VALIDATOR.validate((Object)value, null);
        if (!errors.isEmpty()) {
            IStatus status = (IStatus)errors.get("default.error");
            if (4 == status.getSeverity()) {
                this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
                this.setValid(false);
                return;
            }
            this.setMessage(((IStatus)errors.get("default.error")).getMessage(), 2);
            this.warning = true;
            this.setValid(true);
        }
        if ((installedVersion = this.getInstalledSeamVersion()) != null && seamRuntime.getVersion() != installedVersion) {
            this.setMessage(NLS.bind((String)SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_WRONG_SEAM_VERSION, (Object[])new String[]{seamRuntime.getVersion().toString(), installedVersion.toString()}), 2);
            this.warning = true;
            this.setValid(true);
        }
        this.validateProjectName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MAIN_SEAM_PROJECT_DOES_NOT_EXIST, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MAIN_SEAM_PROJECT_IS_EMPTY, "seam.project.name", false);
        boolean deployAsEar = "ear".equals(this.getValue("seam.project.deployment.type"));
        if (deployAsEar) {
            this.validateProjectName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_EJB_PROJECT_DOES_NOT_EXIST, null, "seam.ejb.project", true);
        }
        if ((viewFolder = this.getValue("seam.project.web.root.folder").trim()).length() > 0) {
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(viewFolder);
            if (folder == null || !folder.exists()) {
                if (!this.error) {
                    this.setErrorMessage(NLS.bind((String)SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_VIEW_FOLDER_DOES_NOT_EXIST, (Object[])new String[]{viewFolder}));
                }
                this.error = true;
                this.setValid(false);
            }
        } else {
            this.setMessage(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_VIEW_FOLDER_IS_EMPTY, 2);
            this.warning = true;
        }
        this.validateSourceFolder(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MODEL_SOURCE_FOLDER_DOES_NOT_EXIST, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MODEL_SOURCE_FOLDER_IS_EMPTY, "model.sources", "model.package");
        this.validateJavaPackageName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MODEL_PACKAGE_IS_NOT_VALID, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_MODEL_PACKAGE_HAS_WARNING, "model.package");
        this.validateSourceFolder(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_ACTION_SOURCE_FOLDER_DOES_NOT_EXIST, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_ACTION_SOURCE_FOLDER_IS_EMPTY, "action.sources", "action.package");
        this.validateJavaPackageName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_ACTION_PACKAGE_IS_NOT_VALID, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_ACTION_PACKAGE_HAS_WARNING, "action.package");
        if (this.isTestEnabled()) {
            this.validateSourceFolder(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_SOURCE_FOLDER_DOES_NOT_EXIST, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_SOURCE_FOLDER_IS_EMPTY, "test.sources", "test.package");
            this.validateProjectName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_PROJECT_DOES_NOT_EXIST, null, "seam.test.project", true);
            this.validateJavaPackageName(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_PACKAGE_IS_NOT_VALID, SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_TEST_PACKAGE_HAS_WARNING, "test.package");
        }
        if (this.error) {
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
        if (!this.warning) {
            this.setMessage(null, 2);
        }
    }

    private boolean validateJavaPackageName(String errorMessageKey, String warningMessageKey, String editorName) {
        if (((IFieldEditor)this.editorRegistry.get(editorName)).isEnabled()) {
            String packageName = this.getValue(editorName).trim();
            if (packageName.length() == 0) {
                this.setMessage(NLS.bind((String)warningMessageKey, (Object[])new String[]{SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_PACKAGE_IS_BLANK}), 2);
                this.warning = true;
                return true;
            }
            IStatus status = JavaConventions.validatePackageName((String)packageName, (String)"1.5", (String)"1.5");
            if (status.getSeverity() == 4) {
                if (!this.error) {
                    this.setErrorMessage(NLS.bind((String)errorMessageKey, (Object[])new String[]{status.getMessage()}));
                }
                this.error = true;
                this.setValid(false);
                return false;
            }
            if (status.getSeverity() == 2) {
                if (!this.error) {
                    this.setMessage(NLS.bind((String)warningMessageKey, (Object[])new String[]{status.getMessage()}), 2);
                }
                this.warning = true;
                return true;
            }
        }
        return true;
    }

    private boolean validateProjectName(String errorMessageKeyForNonexistedProject, String errorMessageKeyForEmptyProject, String editorName, boolean canBeEmpty) {
        String projectName = this.getValue(editorName).trim();
        if (projectName.length() == 0) {
            if (!canBeEmpty) {
                if (!this.error) {
                    this.setErrorMessage(errorMessageKeyForEmptyProject);
                    this.setValid(false);
                }
                this.error = true;
                this.setValid(false);
                return false;
            }
        } else if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            if (!this.error) {
                this.setErrorMessage(NLS.bind((String)errorMessageKeyForNonexistedProject, (Object[])new String[]{projectName}));
            }
            this.error = true;
            this.setValid(false);
            return false;
        }
        return true;
    }

    private boolean validateSourceFolder(String errorMessageKey, String warningMessage, String sourceFolderEditorName, String packageEditorName) {
        String sourceFolder = this.getValue(sourceFolderEditorName).trim();
        if (sourceFolder.length() > 0) {
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolder);
            if (folder == null || !(folder instanceof IFolder) || !folder.exists()) {
                ((IFieldEditor)this.editorRegistry.get(packageEditorName)).setEnabled(false);
                if (!this.error) {
                    this.setErrorMessage(NLS.bind((String)errorMessageKey, (Object[])new String[]{sourceFolder}));
                }
                this.error = true;
                this.setValid(false);
                return false;
            }
            ((IFieldEditor)this.editorRegistry.get(packageEditorName)).setEnabled(true);
        } else {
            this.setMessage(warningMessage, 2);
            this.warning = true;
            ((IFieldEditor)this.editorRegistry.get(packageEditorName)).setEnabled(false);
        }
        return true;
    }

    private String getSeamRuntimeName() {
        if (this.preferences != null) {
            SeamRuntime defaultRuntime = SeamRuntimeManager.getDefaultRuntimeForProject((IProject)(this.warProject != null ? this.warProject : this.project));
            if (defaultRuntime == null) {
                defaultRuntime = SeamRuntimeManager.getInstance().getDefaultRuntime();
            }
            return this.preferences.get("seam.runtime.name", defaultRuntime == null ? "" : defaultRuntime.getName());
        }
        return "";
    }

    private String getSeamProjectName() {
        return this.getSeamProject().getName();
    }

    private String getDefaultTestProjectName() {
        IProject testProject = this.seamProjectSet.getTestProject();
        if (testProject != null) {
            return testProject.getName();
        }
        return this.getSeamProjectName();
    }

    private IProject getSeamProject() {
        return this.warProject != null ? this.warProject : this.project;
    }

    private String getTestProjectName() {
        String projectName = "";
        if (this.preferences != null) {
            projectName = this.preferences.get("seam.test.project", this.getSeamProjectName());
        }
        return projectName;
    }

    public boolean performOk() {
        if (this.isSeamSupported()) {
            SeamUtil.enableSeamSupport((IProject)this.project);
            SeamUtil.enableSeamSupport((IProject)this.warProject);
            if (this.warProject != null) {
                IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)this.warProject);
                prefs.putBoolean("seam.settings.changed.by.user", true);
            } else {
                IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)this.project);
                prefs.putBoolean("seam.settings.changed.by.user", true);
            }
            this.storeSettings();
        } else {
            this.removeSeamSupport();
        }
        return true;
    }

    private void storeSettings() {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences childProjectPrefs = projectScope.getNode("org.jboss.tools.seam.core");
        IEclipsePreferences prefs = this.preferences;
        if (prefs == null) {
            prefs = childProjectPrefs;
        }
        if (this.project != this.getSeamProject()) {
            childProjectPrefs.put("seam.parent.project", this.getValue("seam.project.name"));
        }
        prefs.put("seam.project.settings.version", "1.1");
        prefs.put("seam.project.deployment.type", this.getValue("seam.project.deployment.type"));
        prefs.put("seam.runtime.name", this.getValue("seam.runtime.name"));
        prefs.put("action.package", this.getValue("action.package"));
        prefs.put("model.package", this.getValue("model.package"));
        prefs.put("test.package", this.getValue("test.package"));
        prefs.put("seam.test.creating", this.getValue("seam.test.creating"));
        prefs.put("test.sources", this.getValue("test.sources"));
        prefs.put("seam.test.project", this.getValue("seam.test.project"));
        prefs.put("seam.ejb.project", this.getValue("seam.ejb.project"));
        prefs.put("model.sources", this.getValue("model.sources"));
        prefs.put("action.sources", this.getValue("action.sources"));
        prefs.put("seam.project.web.root.folder", this.getValue("seam.project.web.root.folder"));
        try {
            prefs.flush();
            if (prefs != childProjectPrefs) {
                childProjectPrefs.flush();
            }
        }
        catch (BackingStoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private boolean isSeamSupported() {
        return this.suportSeam;
    }

    public void setEnabledSeamSuport(boolean enabled) {
        this.suportSeam = enabled;
        ((IFieldEditor)this.editorRegistry.get(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT)).setValue((Object)enabled);
        if (!enabled) {
            this.setEnabledGroups(enabled);
            for (String key : this.editorRegistry.keySet()) {
                if (key == SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT) continue;
                ((IFieldEditor)this.editorRegistry.get(key)).setEnabled(enabled);
            }
        } else {
            ((IFieldEditor)this.editorRegistry.get("seam.runtime.name")).setEnabled(enabled);
            if (this.runtimeIsSelected) {
                this.setEnabledGroups(enabled);
                for (String key : this.editorRegistry.keySet()) {
                    if (key == SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT || key == "seam.test.project" || key == "test.sources" || key == "test.package.path" || key == "seam.ejb.project") continue;
                    ((IFieldEditor)this.editorRegistry.get(key)).setEnabled(enabled);
                }
                this.setEnabledTestGroup();
                this.setEnabledDeploymentGroup();
            }
        }
    }

    private void setEnabledDeploymentGroup() {
        IFieldEditor deployment = (IFieldEditor)this.editorRegistry.get("seam.project.deployment.type");
        ((IFieldEditor)this.editorRegistry.get("seam.ejb.project")).setEnabled("ear".equals(deployment.getValue()));
    }

    private void setEnabledTestGroup() {
        boolean enabled;
        boolean seam23 = this.isSeam23();
        boolean bl = enabled = this.isTestEnabled() && this.isSeamSupported() && this.runtimeIsSelected && !seam23;
        if (seam23) {
            this.getEditor("seam.test.creating").setValue((Object)Boolean.FALSE);
        }
        this.getEditor("seam.test.creating").setEnabled(!seam23 && this.getSeamRuntime() != null);
        ((IFieldEditor)this.editorRegistry.get("seam.test.project")).setEnabled(enabled);
        ((IFieldEditor)this.editorRegistry.get("test.sources")).setEnabled(enabled);
        ((IFieldEditor)this.editorRegistry.get("test.package")).setEnabled(enabled);
    }

    private boolean isSeam23() {
        SeamRuntime seamRuntime = this.getSeamRuntime();
        return seamRuntime != null && seamRuntime.getVersion() == SeamVersion.SEAM_2_3;
    }

    private SeamRuntime getSeamRuntime() {
        String value = this.getValue("seam.runtime.name");
        return SeamRuntimeManager.getInstance().findRuntimeByName(value);
    }

    private boolean isTestEnabled() {
        IFieldEditor createTestCheckBox = (IFieldEditor)this.editorRegistry.get("seam.test.creating");
        return (Boolean)createTestCheckBox.getValue();
    }

    private void setEnabledGroups(boolean enabled) {
        for (Group group : this.groups) {
            group.setEnabled(enabled);
        }
    }

    protected void performDefaults() {
        this.getEditor(SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT).setValue((Object)Boolean.TRUE);
        this.getEditor("seam.runtime.name").setValue((Object)this.getDefaultRuntimeName());
        IProject mainProject = SeamWizardUtils.getRootSeamProject(this.project);
        this.getEditor("seam.project.name").setValue((Object)(mainProject != null ? mainProject.getName() : this.project.getName()));
        this.getEditor("seam.project.deployment.type").setValue((Object)this.seamProjectSet.getDefaultDeployType());
        this.getEditor("seam.ejb.project").setValue((Object)(this.seamProjectSet.getEjbProject() == null ? this.project.getName() : this.seamProjectSet.getEjbProject().getName()));
        this.getEditor("seam.project.web.root.folder").setValue((Object)this.getDefaultViewFolder());
        this.getEditor("model.sources").setValue((Object)this.getDefaultModelSourceFolder());
        this.getEditor("model.package").setValue((Object)this.getDefaultModelPackageName());
        this.getEditor("action.sources").setValue((Object)this.getDefaultActionSourceFolder());
        this.getEditor("action.package").setValue((Object)this.getDefaultActionPackageName());
        this.getEditor("seam.test.creating").setValue((Object)Boolean.TRUE);
        this.getEditor("seam.test.project").setValue((Object)this.getDefaultTestProjectName());
        this.getEditor("test.sources").setValue((Object)this.getDefaultTestSourceFolder());
        this.getEditor("test.package").setValue((Object)this.getDefaultTestPackageName());
        this.setEnabledSeamSuport(true);
        this.validate();
    }

    private String getDefaultRuntimeName() {
        SeamRuntime runtime = SeamRuntimeManager.getDefaultRuntimeForProject((IProject)this.getSeamProject());
        if (runtime == null) {
            List<String> names = this.getRuntimeNames();
            if (!names.isEmpty()) {
                return names.get(0);
            }
            return "";
        }
        return runtime.getName();
    }

    private List<String> getRuntimeNames() {
        SeamVersion[] seamVersions = this.getSeamVersions();
        ArrayList<String> rtStrings = new ArrayList<String>();
        int i = 0;
        while (i < seamVersions.length) {
            SeamRuntime[] rts;
            SeamRuntime[] seamRuntimeArray = rts = SeamRuntimeManager.getInstance().getRuntimes(seamVersions[i]);
            int n = rts.length;
            int n2 = 0;
            while (n2 < n) {
                SeamRuntime seamRuntime = seamRuntimeArray[n2];
                rtStrings.add(seamRuntime.getName());
                ++n2;
            }
            ++i;
        }
        return rtStrings;
    }

    private void setRuntimeIsSelected(boolean selected) {
        this.runtimeIsSelected = selected;
        for (String key : this.editorRegistry.keySet()) {
            if (key == SeamPreferencesMessages.SEAM_SETTINGS_PREFERENCE_PAGE_SEAM_SUPPORT || key == "seam.runtime.name") continue;
            ((IFieldEditor)this.editorRegistry.get(key)).setEnabled(selected);
        }
        this.setEnabledGroups(selected);
        this.setEnabledTestGroup();
        this.setEnabledDeploymentGroup();
    }

    private void removeSeamSupport() {
        try {
            EclipseResourceUtil.removeNatureFromProject((IProject)this.project, (String)"org.jboss.tools.seam.core.seamnature");
        }
        catch (CoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private SeamVersion[] getSeamVersions() {
        return SeamVersion.ALL_VERSIONS;
    }

    private SeamVersion getInstalledSeamVersion() {
        if (this.warSeamProject != null) {
            try {
                SeamVersion seamVersion;
                IProjectFacet facet;
                IProjectFacetVersion version;
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.warSeamProject.getProject());
                if (facetedProject != null && (version = facetedProject.getInstalledVersion(facet = ProjectFacetsManager.getProjectFacet((String)"jst.seam"))) != null && (seamVersion = SeamVersion.findByString((String)version.getVersionString())) != null) {
                    return seamVersion;
                }
            }
            catch (CoreException e) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    private String getJBossSeamJarLocation() {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.project);
        if (jp == null) {
            return null;
        }
        IClasspathEntry[] es = null;
        try {
            es = jp.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (es == null) {
            return null;
        }
        int i = 0;
        while (i < es.length) {
            IFile f;
            IPath p = es[i].getPath();
            if (p != null && p.lastSegment().equalsIgnoreCase("jboss-seam.jar") && (f = ResourcesPlugin.getWorkspace().getRoot().getFile(p)) != null && f.exists()) {
                return f.getLocation().toString();
            }
            ++i;
        }
        return null;
    }
}

