/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimePathPreferenceIO {
    private static final String RUNTIME_PATHS = "runtimePaths";
    private static final String PATH = "path";
    private static final String RUNTIME_PATH = "runtimePath";
    private static final String SCAN_ON_EVERY_STAERTUP = "scanOnEveryStartup";
    private static final String TIMESTAMP = "timestamp";
    private static final String SERVER_DEFINITIONS = "serverDefinitions";
    private static final String SERVER_DEFINITION = "serverDefinition";
    private static final String NAME = "name";
    private static final String INCLUDED_DEFINITION = "included";
    private static final String VERSION = "version";
    private static final String TYPE = "type";
    private static final String LOCATION = "location";
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";
    public static final String FIRST_START = "firstStart";
    public static final String PREFERENCES_VERSION = "version";
    private static final String RUNTIME_PREFERENCES_VERSION = "2";

    public static String getPreferenceOutputString(Set<RuntimePath> runtimePaths) throws IOException {
        String string;
        block8: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)RUNTIME_PATHS);
            memento.putString("version", RUNTIME_PREFERENCES_VERSION);
            for (RuntimePath runtimePath : runtimePaths) {
                IMemento runtimePathNode = memento.createChild(RUNTIME_PATH);
                runtimePathNode.putString(PATH, runtimePath.getPath());
                runtimePathNode.putBoolean(SCAN_ON_EVERY_STAERTUP, runtimePath.isScanOnEveryStartup());
                runtimePathNode.putString(TIMESTAMP, String.valueOf(runtimePath.getTimestamp()));
                IMemento runtimeDefinitionsNode = runtimePathNode.createChild(SERVER_DEFINITIONS);
                RuntimeDefinition[] definitions = runtimePath.getRuntimeDefinitions();
                RuntimePathPreferenceIO.putDefinitions(runtimeDefinitionsNode, definitions);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream os = new BufferedOutputStream(baos);
            try {
                String runtimes;
                memento.save((OutputStream)os);
                os.flush();
                string = runtimes = baos.toString();
                if (os == null) break block8;
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private static void putDefinitions(IMemento runtimeDefintionsNode, RuntimeDefinition[] definitions) {
        RuntimeDefinition[] runtimeDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeDefinition runtimeDefinition = runtimeDefinitionArray[n2];
            IMemento sdNode = runtimeDefintionsNode.createChild(SERVER_DEFINITION);
            RuntimePathPreferenceIO.putRuntimeDefinition(runtimeDefinition, sdNode);
            IMemento includedNodes = sdNode.createChild(INCLUDED_DEFINITION);
            for (RuntimeDefinition included : runtimeDefinition.getIncludedRuntimeDefinitions()) {
                IMemento includedNode = includedNodes.createChild(SERVER_DEFINITION);
                RuntimePathPreferenceIO.putRuntimeDefinition(included, includedNode);
            }
            ++n2;
        }
    }

    private static void putRuntimeDefinition(RuntimeDefinition runtimeDefinition, IMemento node) {
        node.putString(NAME, runtimeDefinition.getName());
        node.putString("version", runtimeDefinition.getVersion());
        node.putString(TYPE, runtimeDefinition.getType());
        node.putString(LOCATION, runtimeDefinition.getLocation().getAbsolutePath());
        node.putString(DESCRIPTION, runtimeDefinition.getDescription());
        node.putBoolean(ENABLED, runtimeDefinition.isEnabled());
    }

    public static Set<RuntimePath> loadRuntimePathsFromPreferenceString(String preferenceString) {
        IMemento[] nodes;
        HashSet<RuntimePath> runtimePaths = new HashSet<RuntimePath>();
        if (preferenceString == null || preferenceString.isEmpty()) {
            return runtimePaths;
        }
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(preferenceString.getBytes()));
        XMLMemento memento = XMLMemento.createReadRoot((InputStream)is);
        String preferencesVersion = memento.getString("version");
        boolean computeIncluded = preferencesVersion == null;
        IMemento[] iMementoArray = nodes = memento.getChildren(RUNTIME_PATH);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento[] sdNodes;
            IMemento node = iMementoArray[n2];
            String path = node.getString(PATH);
            boolean scanOnEveryStartup = node.getBoolean(SCAN_ON_EVERY_STAERTUP);
            String tsString = node.getString(TIMESTAMP);
            Long timestamp = null;
            try {
                timestamp = new Long(tsString);
            }
            catch (NumberFormatException numberFormatException) {}
            RuntimePath runtimePath = new RuntimePath(path);
            runtimePath.setScanOnEveryStartup(scanOnEveryStartup);
            if (timestamp != null) {
                runtimePath.setTimestamp(timestamp);
            }
            IMemento serverDefinitionsNode = node.getChild(SERVER_DEFINITIONS);
            IMemento[] iMementoArray2 = sdNodes = serverDefinitionsNode.getChildren(SERVER_DEFINITION);
            int n3 = sdNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento sdNode = iMementoArray2[n4];
                RuntimeDefinition runtimeDefinition = RuntimePathPreferenceIO.createRuntimeDefinition(sdNode);
                runtimeDefinition.setRuntimePath(runtimePath);
                IMemento includedDefinition = sdNode.getChild(INCLUDED_DEFINITION);
                if (includedDefinition != null) {
                    IMemento[] includedNodes;
                    IMemento[] iMementoArray3 = includedNodes = includedDefinition.getChildren(SERVER_DEFINITION);
                    int n5 = includedNodes.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMemento includedNode = iMementoArray3[n6];
                        RuntimeDefinition included = RuntimePathPreferenceIO.createRuntimeDefinition(includedNode);
                        included.setRuntimePath(runtimePath);
                        included.setParent(runtimeDefinition);
                        runtimeDefinition.getIncludedRuntimeDefinitions().add(included);
                        ++n6;
                    }
                }
                runtimePath.addRuntimeDefinition(runtimeDefinition);
                ++n4;
            }
            runtimePaths.add(runtimePath);
            ++n2;
        }
        if (computeIncluded) {
            for (RuntimeDefinition definition : RuntimePathPreferenceIO.getAllRuntimeDefinitions(runtimePaths)) {
                Set<IRuntimeDetector> detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
                for (IRuntimeDetector detector : detectors) {
                    detector.computeIncludedRuntimeDefinition(definition);
                }
            }
        }
        return runtimePaths;
    }

    private static RuntimeDefinition createRuntimeDefinition(IMemento node) {
        String name = node.getString(NAME);
        String version = node.getString("version");
        String type = node.getString(TYPE);
        String location = node.getString(LOCATION);
        String description = node.getString(DESCRIPTION);
        boolean enabled = node.getBoolean(ENABLED);
        RuntimeDefinition runtimeDefinition = new RuntimeDefinition(name, version, type, new File(location));
        runtimeDefinition.setDescription(description);
        runtimeDefinition.setEnabled(enabled);
        return runtimeDefinition;
    }

    private static List<RuntimeDefinition> getAllRuntimeDefinitions(Set<RuntimePath> paths) {
        ArrayList<RuntimeDefinition> defs = new ArrayList<RuntimeDefinition>();
        Iterator<RuntimePath> i = paths.iterator();
        while (i.hasNext()) {
            defs.addAll(Arrays.asList(i.next().getRuntimeDefinitions()));
        }
        return defs;
    }
}

