/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.ChangedFileOutputStream;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public abstract class AbstractEclipseBuildContext
implements BuildContext,
IIncrementalBuildFramework.BuildContext {
    protected final Map<String, Object> context;
    private final IIncrementalBuildFramework.BuildResultCollector results;

    protected AbstractEclipseBuildContext(Map<String, Object> context, IIncrementalBuildFramework.BuildResultCollector results) {
        this.context = context;
        this.results = results;
    }

    public void refresh(File file) {
        this.results.refresh(file);
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return new ChangedFileOutputStream(file, this);
    }

    protected IPath getRelativePath(File file) {
        IPath path;
        IPath basepath = this.getBaseResource().getLocation();
        if (!basepath.isPrefixOf(path = Path.fromOSString((String)file.getAbsolutePath()))) {
            return null;
        }
        return path.removeFirstSegments(basepath.segmentCount());
    }

    protected IResource getResource(File file) {
        IPath relpath = this.getRelativePath(file);
        if (relpath == null) {
            return null;
        }
        IResource baseResource = this.getBaseResource();
        if (baseResource instanceof IContainer) {
            return ((IContainer)baseResource).findMember(relpath);
        }
        return null;
    }

    protected abstract IResource getBaseResource();

    public void setValue(String key, Object value) {
        this.context.put(key, value);
    }

    public Object getValue(String key) {
        return this.context.get(key);
    }

    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        this.results.addMessage(file, line, column, message, severity, cause);
    }

    public void removeMessages(File file) {
        this.results.removeMessages(file);
    }

    public boolean isUptodate(File target, File source) {
        IResource targetResource = this.getResource(target);
        IResource sourceResource = this.getResource(source);
        return targetResource != null && targetResource.isAccessible() && !this.hasDelta(target) && sourceResource != null && sourceResource.isAccessible() && !this.hasDelta(source) && targetResource.getLocalTimeStamp() >= sourceResource.getLocalTimeStamp();
    }

    @Override
    public void release() {
        ThreadBuildContext.setThreadBuildContext(null);
    }
}

