/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.internal.furnace.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.jboss.tools.forge.core.furnace.repository.FurnaceRepository;
import org.jboss.tools.forge.core.furnace.repository.IFurnaceRepository;
import org.jboss.tools.forge.core.furnace.repository.IFurnaceRepositoryProvider;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;

public class FurnaceRepositoryManager {
    private static final String FURNACE_REPOSITORY_EXTENSION_POINT = "furnaceRepository";
    private static final String REPOSITORY_PATH_ELEM = "repositoryPath";
    private static final String REPOSITORY_PROVIDER_ELEM = "repositoryProvider";
    private static final String PATH_ATTR = "path";
    private static final String MUTABLE_ATTR = "mutable";
    private static final String PROVIDER_ATTR = "provider";
    private static FurnaceRepositoryManager handler;
    private List<IFurnaceRepository> repositories;
    private List<ClassLoader> loaders;

    private FurnaceRepositoryManager() {
    }

    public static FurnaceRepositoryManager getDefault() {
        if (handler == null) {
            handler = new FurnaceRepositoryManager();
        }
        return handler;
    }

    public List<IFurnaceRepository> getRepositories() {
        if (this.repositories == null) {
            this.load();
        }
        return this.repositories;
    }

    private void load() {
        IConfigurationElement[] configElems;
        final ArrayList<FurnaceRepository> repos = new ArrayList<FurnaceRepository>();
        final ArrayList loaders = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = configElems = Platform.getExtensionRegistry().getConfigurationElementsFor("org.jboss.tools.forge.core", FURNACE_REPOSITORY_EXTENSION_POINT);
        int n = configElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElem = iConfigurationElementArray[n2];
            switch (configElem.getName()) {
                case "repositoryPath": {
                    String path = configElem.getAttribute(PATH_ATTR);
                    boolean mutable = Boolean.parseBoolean(configElem.getAttribute(MUTABLE_ATTR));
                    if (path == null || path.isEmpty()) break;
                    repos.add(new FurnaceRepository(path, mutable));
                    break;
                }
                case "repositoryProvider": {
                    try {
                        final IFurnaceRepositoryProvider provider = (IFurnaceRepositoryProvider)configElem.createExecutableExtension(PROVIDER_ATTR);
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                repos.addAll(provider.getRepositories());
                                loaders.add(provider.getClassLoader());
                            }

                            public void handleException(Throwable t) {
                                ForgeCorePlugin.log(t);
                            }
                        });
                        break;
                    }
                    catch (CoreException e) {
                        ForgeCorePlugin.log(e);
                    }
                }
            }
            ++n2;
        }
        this.repositories = Collections.unmodifiableList(repos);
        this.loaders = Collections.unmodifiableList(loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        if (this.loaders == null) {
            this.load();
        }
        return this.loaders;
    }
}

