/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup;

import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.tools.maven.sourcelookup.SourcelookupLaunchConfigurationListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class SourceLookupActivator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.jboss.tools.maven.sourcelookup.core";
    public static final String AS7_LAUNCH_CONFIGURATION_ID = "org.jboss.ide.eclipse.as.core.server.JBoss7StartupConfiguration";
    public static final String AS_LAUNCH_CONFIGURATION_ID = "org.jboss.ide.eclipse.as.core.server.startupConfiguration";
    private static final String MAVEN_PLUGIN_ID = "org.eclipse.m2e.core";
    public static final String JBOSS_LAUNCH_SOURCE_PATH_COMPUTER_ID = "org.jboss.tools.maven.sourcelookup.SourcePathComputer";
    public static final String AUTO_ADD_JBOSS_SOURCE_CONTAINER = "autoAddJBossSourceContainer";
    public static final boolean AUTO_ADD_JBOSS_SOURCE_CONTAINER_DEFAULT = false;
    public static final String AUTO_ADD_JBOSS_SOURCE_ATTACHMENT = "autoAddProjectSourceAttachment";
    public static final String AUTO_ADD_JBOSS_SOURCE_ATTACHMENT_ALWAYS = "always";
    public static final String AUTO_ADD_JBOSS_SOURCE_ATTACHMENT_NEVER = "never";
    public static final String AUTO_ADD_JBOSS_SOURCE_ATTACHMENT_PROMPT = "prompt";
    public static final String AUTO_ADD_JBOSS_SOURCE_ATTACHMENT_DEFAULT = "prompt";
    private static SourceLookupActivator plugin;
    private SourcelookupLaunchConfigurationListener listener;
    private BundleContext context;
    private IPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        plugin = this;
        this.listener = new SourcelookupLaunchConfigurationListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.context = null;
        if (this.listener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
        }
        this.savePreferences();
    }

    public static SourceLookupActivator getDefault() {
        return plugin;
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logInfo(String message) {
        Status status = new Status(1, PLUGIN_ID, message);
        SourceLookupActivator.log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        SourceLookupActivator.log((IStatus)status);
    }

    public ILog getLog() {
        Bundle bundle = this.context.getBundle();
        return InternalPlatform.getDefault().getLog(bundle);
    }

    public static boolean m2eExists() {
        Bundle bundle = Platform.getBundle((String)MAVEN_PLUGIN_ID);
        return bundle != null;
    }

    public static IEclipsePreferences getPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return prefs;
    }

    public void savePreferences() {
        IEclipsePreferences prefs = SourceLookupActivator.getPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SourceLookupActivator.log(e);
        }
    }

    public boolean isAutoAddSourceContainer() {
        return SourceLookupActivator.getPreferences().getBoolean(AUTO_ADD_JBOSS_SOURCE_CONTAINER, false);
    }

    public static boolean isJBossAsLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return AS7_LAUNCH_CONFIGURATION_ID.equals(configuration.getType().getIdentifier()) || AS_LAUNCH_CONFIGURATION_ID.equals(configuration.getType().getIdentifier());
    }

    public String getAutoAddSourceAttachment() {
        return SourceLookupActivator.getPreferences().get(AUTO_ADD_JBOSS_SOURCE_ATTACHMENT, "prompt");
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        }
        return this.preferenceStore;
    }
}

