/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class CheckFilterMappingName
extends Check {
    static String ATTR = "filter-name";

    public CheckFilterMappingName(ValidationErrorManager manager, String preference) {
        super(manager, preference, ATTR);
    }

    @Override
    public void check(XModelObject object) {
        String filterName = object.getAttributeValue(ATTR);
        if (filterName == null) {
            return;
        }
        if (filterName.length() == 0) {
            this.fireMessage(object, WebXMLValidatorMessages.EMPTY, ATTR);
        } else if (this.findFilter(object, filterName) == null) {
            this.fireMessage(object, WebXMLValidatorMessages.FILTER_NOT_EXISTS, ATTR, filterName);
        }
    }

    XModelObject findFilter(XModelObject mapping, String name) {
        XModelObject webxml = WebAppHelper.getParentFile(mapping);
        XModelObject[] cs = WebAppHelper.getFilters(webxml);
        if (cs != null) {
            int i = 0;
            while (i < cs.length) {
                if (name.equals(cs[i].getAttributeValue(ATTR))) {
                    return cs[i];
                }
                ++i;
            }
        }
        return null;
    }
}

