/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.tld.model.TLDUtil;
import org.jboss.tools.jst.web.tld.model.helpers.TLDToPaletteHelper;

public class PaletteAdopt
implements XAdoptManager {
    TLDToPaletteHelper helper = new TLDToPaletteHelper();

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        return this.isAdoptableTag(target, object) || this.isAdoptableTaglib(target, object) || this.isAdoptableFaceletTaglib(target, object);
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableTag(target, object)) {
            this.adoptTag(target, object);
        } else if (this.isAdoptableTaglib(target, object)) {
            this.adoptTaglib(target, object);
        } else if (this.isAdoptableFaceletTaglib(target, object)) {
            this.adoptFaceletTaglib(target, object);
        }
    }

    protected boolean isAdoptableTag(XModelObject target, XModelObject object) {
        if (!TLDUtil.isTag(object)) {
            return false;
        }
        return this.isPaletteObject(target, true);
    }

    private boolean isPaletteObject(XModelObject target, boolean excludeRoot) {
        String te = target.getModelEntity().getName();
        if (te.startsWith("SharablePageTab")) {
            return true;
        }
        if (te.startsWith("SharableGroup")) {
            return true;
        }
        if (te.startsWith("SharableMacro")) {
            return true;
        }
        return !excludeRoot && te.startsWith("SharablePalette");
    }

    protected boolean isAdoptableTaglib(XModelObject target, XModelObject object) {
        if (!TLDUtil.isTaglib(object)) {
            return false;
        }
        return this.isPaletteObject(target, false);
    }

    protected boolean isAdoptableFaceletTaglib(XModelObject target, XModelObject object) {
        if (!TLDUtil.isFaceletTaglib(object)) {
            return false;
        }
        return this.isPaletteObject(target, false);
    }

    public void adoptTag(XModelObject target, XModelObject object) throws XModelException {
        if (target.getModelEntity().getName().startsWith("SharableMacro")) {
            target = target.getParent();
        }
        PaletteAdopt.add(target, object, this.helper.createMacroByTag(object, target.getModel()));
    }

    public void adoptTaglib(XModelObject target, XModelObject object) {
        if (target.getModelEntity().getName().startsWith("SharablePalette")) {
            this.adoptTaglib2(target, object);
        } else if ((target = this.getTab(target)) != null) {
            this.adoptTaglib2(target, object);
        }
    }

    public void adoptTaglib2(XModelObject target, XModelObject object) {
        XModelObject paletteRoot = target;
        while (paletteRoot != null && !paletteRoot.getModelEntity().getName().startsWith("SharablePalette")) {
            paletteRoot = paletteRoot.getParent();
        }
        if (paletteRoot == null) {
            return;
        }
        Properties p = new Properties();
        p.put("initialSelection", object);
        if (paletteRoot != target) {
            p.put("target", target);
        }
        XActionInvoker.invoke((String)"ImportTLDToPaletteWizard", (String)"CreateActions.ImportTLD", (XModelObject)paletteRoot, (Properties)p);
    }

    public void adoptFaceletTaglib(XModelObject target, XModelObject object) {
        this.adoptTaglib(target, object);
    }

    static void add(XModelObject target, XModelObject object, XModelObject created) throws XModelException {
        if (created == null) {
            return;
        }
        XModelObject old = target.getChildByPath(created.getPathPart());
        if (old != null) {
            ServiceDialog d = object.getModel().getService();
            String mes = String.valueOf(DefaultCreateHandler.title((XModelObject)target, (boolean)true)) + " contains " + DefaultCreateHandler.title((XModelObject)old, (boolean)false);
            d.showDialog(WebUIMessages.WARNING, mes, new String[]{WebUIMessages.OK}, null, 2);
        } else {
            DefaultCreateHandler.addCreatedObject((XModelObject)target, (XModelObject)created, (int)-1);
        }
    }

    private XModelObject getTab(XModelObject target) {
        while (target != null && !target.getModelEntity().getName().equals("SharablePageTabHTML")) {
            target = target.getParent();
        }
        return target;
    }
}

