/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateSupport;
import org.jboss.tools.jst.web.project.handlers.EditProjectTemplateSupport;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.ProjectTemplate;
import org.jboss.tools.jst.web.project.version.ProjectVersion;
import org.jboss.tools.jst.web.project.version.ProjectVersions;

public abstract class AbstractWebProjectTemplate
implements IWebProjectTemplate {
    protected abstract String getNatureDir();

    @Override
    public abstract ProjectVersions getProjectVersions();

    @Override
    public String getTemplatesBase() {
        return String.valueOf(WebModelPlugin.getTemplateStateLocation()) + "templates";
    }

    @Override
    public String getProjectTemplatesLocation() {
        return String.valueOf(this.getTemplatesBase()) + "/";
    }

    @Override
    public String getProjectTemplatesLocation(String version) {
        ProjectVersion v = this.getProjectVersions().getVersion(version);
        return v == null ? null : v.getProjectTemplatesLocation();
    }

    @Override
    public String[] getTemplateList(String version) {
        String[] result = new String[]{};
        String location = this.getProjectTemplatesLocation(version);
        if (location == null) {
            return new String[0];
        }
        File templateDir = new File(location);
        if (templateDir.isDirectory()) {
            String[] order = this.getProjectVersions().getVersion(version).getOrder();
            File[] subDirs = templateDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (subDirs != null) {
                TreeSet<String> set = new TreeSet<String>();
                int i = 0;
                while (i < subDirs.length) {
                    set.add(subDirs[i].getName());
                    ++i;
                }
                result = new String[subDirs.length];
                int k = 0;
                int i2 = 0;
                while (i2 < order.length) {
                    if (set.contains(order[i2])) {
                        set.remove(order[i2]);
                        result[k] = order[i2];
                        ++k;
                    }
                    ++i2;
                }
                String[] last = set.toArray(new String[0]);
                System.arraycopy(last, 0, result, k, last.length);
            }
        }
        return result;
    }

    public String getPageTemplatesLocation() {
        return String.valueOf(this.getTemplatesBase()) + "/pages";
    }

    @Override
    public String[] getVersionList() {
        return this.getProjectVersions().getVersionList();
    }

    @Override
    public String[] getLibraries(String version) {
        ArrayList<String> jars = new ArrayList<String>();
        ProjectVersion v = this.getProjectVersions().getVersion(version);
        if (v != null) {
            String[] locations = v.getLibraryLocations();
            int k = 0;
            while (k < locations.length) {
                File[] fs;
                if (locations[k] != null && new File(locations[k]).isDirectory() && (fs = new File(locations[k]).listFiles()) != null) {
                    int i = 0;
                    while (i < fs.length) {
                        String path;
                        if (fs[i].isFile() && !jars.contains(path = fs[i].getAbsolutePath())) {
                            jars.add(path);
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
        return jars.toArray(new String[jars.size()]);
    }

    protected String getDefaultVersion(String preference) {
        String[] vs = this.getVersionList();
        if (vs.length == 0) {
            return "";
        }
        int i = 0;
        while (i < vs.length) {
            if (vs[i].equals(preference)) {
                return preference;
            }
            ++i;
        }
        return vs[0];
    }

    protected String getDefaultTemplate(String version, String preference) {
        String[] vs = this.getTemplateList(version);
        if (vs == null || vs.length == 0) {
            return "";
        }
        int i = 0;
        while (i < vs.length) {
            if (vs[i].equals(preference)) {
                return preference;
            }
            ++i;
        }
        return vs[0];
    }

    public void setDefaultTemplate(String template) {
    }

    protected abstract String getWizardEntitySuffix();

    public String addProjectTemplate(String version) {
        return AddProjectTemplateSupport.run(this, "ProjectTemplate" + this.getWizardEntitySuffix(), version);
    }

    public String addProjectTemplate(IProject project) {
        return AddProjectTemplateSupport.run(this, "ProjectTemplate" + this.getWizardEntitySuffix(), project);
    }

    public String editProjectTemplate(String version, String name) {
        return EditProjectTemplateSupport.run(this, "ProjectTemplate" + this.getWizardEntitySuffix(), version, name);
    }

    public void removeProjectTemplate(String version, String name) {
        String location = this.getProjectTemplatesLocation(version);
        if (location == null) {
            return;
        }
        File f = new File(location);
        if ((f = new File(f, name)).isDirectory()) {
            if (!AbstractWebProjectTemplate.confirm(NLS.bind((String)WebUIMessages.YOU_WANT_TO_DELETE_TEMPLATE, (Object)name, (Object)version))) {
                return;
            }
            FileUtil.remove((File)f);
        }
    }

    static boolean confirm(String message) {
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        return d.showDialog(WebUIMessages.CONFIRMATION, message, new String[]{WebUIMessages.OK, WebUIMessages.CANCEL}, null, 0) == 0;
    }

    @Override
    public ProjectTemplate getProjectTemplate(String version, String name) {
        String location = this.getProjectTemplatesLocation(version);
        if (location == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        ProjectTemplate template = new ProjectTemplate();
        template.setProjectVersion(this.getProjectVersions().getVersion(version));
        template.init(name, location);
        return template;
    }
}

