/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers.autolayout;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;
import org.jboss.tools.jst.web.model.helpers.autolayout.LayuotConstants;

public class AutoPlacement {
    LayuotConstants constants = new LayuotConstants();
    private static WebProcessStructureHelper h = new WebProcessStructureHelper();
    private static int SIZE = 5;
    int[][] field = new int[SIZE][SIZE];
    int x0 = -1;
    int y0 = -1;

    public void place(XModelObject process, XModelObject source, XModelObject target) {
        this.constants.update();
        if (target.getAttributeValue("shape").length() > 0) {
            return;
        }
        if ((source = this.getItem(process, source)) == null) {
            return;
        }
        int[] shape = h.asIntArray(source, "shape");
        if (shape == null || shape.length < 4) {
            return;
        }
        this.x0 = shape[0];
        this.y0 = shape[1];
        this.fillField(process);
        int[] p = this.findPoint();
        if (p != null) {
            target.setAttributeValue("shape", p[0] + "," + p[1] + ",0,0");
        }
    }

    private XModelObject getItem(XModelObject process, XModelObject source) {
        XModelObject p = source.getParent();
        if (p == process) {
            return source;
        }
        source = p;
        return (p = p.getParent()) == process ? source : null;
    }

    private void fillField(XModelObject process) {
        int i = 0;
        while (i < SIZE) {
            int j = 0;
            while (j < SIZE) {
                this.field[i][j] = 0;
                ++j;
            }
            ++i;
        }
        XModelObject[] items = process.getChildren();
        int i2 = 0;
        while (i2 < items.length) {
            int[] shape = h.asIntArray(items[i2], "shape");
            if (shape != null && shape.length >= 4) {
                int x1 = shape[0];
                int y1 = shape[1];
                int ix = (x1 - this.x0 + this.constants.deltaX / 2) / this.constants.deltaX - 1;
                int iy = (y1 - this.y0 + this.constants.deltaY / 2) / this.constants.deltaY;
                if (ix >= 0 && ix < SIZE && iy >= 0 && iy < SIZE) {
                    this.field[ix][iy] = 1;
                }
            }
            ++i2;
        }
    }

    private int[] findPoint() {
        int is = 0;
        while (is < 2 * SIZE) {
            int iy = SIZE - 1;
            while (iy >= 0) {
                int ix = is - iy;
                if (ix >= 0 && ix < SIZE && this.field[ix][iy] != 1) {
                    return new int[]{this.x0 + (ix + 1) * this.constants.deltaX, this.y0 + iy * this.constants.deltaY};
                }
                --iy;
            }
            ++is;
        }
        return null;
    }
}

