/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.project.WebProject;

public class WebUtils {
    public static final String ATTR_WEB_SERVER_NAME = "org.jboss.tools.jst.web.web_server_name";
    public static final String WEB_SERVER_TOMCAT = "Tomcat";
    public static final String APPLICATION_SERVER_J2EE = "J2EE";
    public static final String APPLICATION_SERVER_JBOSS = "JBoss";
    public static String CLASS_PATH_VAR_EXTENSION_POINT_ID = "org.jboss.tools.jst.web.classPathVar";
    public static String VAR_TAG_NAME = "variable";
    public static String VAR_NAME_ATTR = "name";
    public static String NATURE_ID_ATTR = "natureId";

    public static String[] getServletVersions(String templateBase) {
        String location = String.valueOf(templateBase) + "/../lib/servlet";
        File f = new File(location);
        if (!f.isDirectory()) {
            return new String[0];
        }
        File[] fs = f.listFiles();
        TreeSet<String> set = new TreeSet<String>();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isDirectory()) {
                    set.add(fs[i].getName());
                }
                ++i;
            }
        }
        return set.toArray(new String[0]);
    }

    public static String[] getServletLibraries(String templateBase, String servletVersion) {
        String location = String.valueOf(templateBase) + "/../lib/servlet/" + servletVersion;
        File f = new File(location);
        if (!f.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> jars = new ArrayList<String>();
        File[] fs = f.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isFile()) {
                    String path = null;
                    try {
                        path = fs[i].getCanonicalPath();
                    }
                    catch (IOException e) {
                        WebModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                    if (path != null) {
                        jars.add(path);
                    }
                }
                ++i;
            }
        }
        return jars.toArray(new String[jars.size()]);
    }

    public static String getWebRootPath(IProject project) {
        IModelNature modelNature = EclipseResourceUtil.getModelNature((IProject)project);
        return modelNature != null ? WebProject.getInstance(modelNature.getModel()).getWebRootLocation() : null;
    }

    public static IContainer[] getWebRootFolders(IProject project, boolean ignoreDerived) {
        return org.jboss.tools.common.web.WebUtils.getWebRootFolders((IProject)project, (boolean)ignoreDerived);
    }

    public static IContainer[] getWebRootFolders(IProject project) {
        return WebUtils.getWebRootFolders(project, true);
    }

    public static String[] getServletLibraries(String natureId, String templateBase, String servletVersion) {
        String classPathVarName = WebUtils.findClassPathVarByNatureId(natureId);
        if (classPathVarName == null) {
            return WebUtils.getServletLibraries(templateBase, servletVersion);
        }
        String classPathVarValue = JavaCore.getClasspathVariable((String)classPathVarName).toOSString();
        String location = String.valueOf(templateBase) + "/../lib/servlet/" + servletVersion;
        File f = new File(location);
        if (!f.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> jars = new ArrayList<String>();
        File[] fs = f.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isFile()) {
                    String path = null;
                    try {
                        path = fs[i].getCanonicalPath();
                        if (!path.startsWith("/")) {
                            path = "/" + path;
                        }
                        if (path.startsWith(classPathVarValue)) {
                            path = String.valueOf(classPathVarName) + path.substring(classPathVarValue.length());
                        }
                    }
                    catch (IOException e) {
                        WebModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                    if (path != null) {
                        jars.add(path);
                    }
                }
                ++i;
            }
        }
        return jars.toArray(new String[jars.size()]);
    }

    public static String findClassPathVarByNatureId(String nId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(CLASS_PATH_VAR_EXTENSION_POINT_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                if (VAR_TAG_NAME.equals(configurationElements[j].getName())) {
                    String name = configurationElements[j].getAttribute(VAR_NAME_ATTR);
                    String natureId = configurationElements[j].getAttribute(NATURE_ID_ATTR);
                    if (nId.equals(natureId)) {
                        return name;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static IPath getRelativePath(IProject project, String path) {
        return EclipseResourceUtil.getRelativePath((IProject)project, (String)path);
    }

    public static IClasspathEntry[] getDefaultJRELibrary() {
        return EclipseResourceUtil.getDefaultJRELibrary();
    }

    public static void changeTimeStamp(IProject project) throws CoreException {
        if (project == null || !project.isAccessible()) {
            return;
        }
        List<IFile> fs = WebUtils.getFilesToTouch(project);
        int i = 0;
        while (i < fs.size()) {
            IFile f = fs.get(i);
            f.setLocalTimeStamp(System.currentTimeMillis());
            f.touch((IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
    }

    private static List<IFile> getFilesToTouch(IProject project) {
        IVirtualComponent component;
        IPath path;
        IFile f;
        ArrayList<IFile> fs = new ArrayList<IFile>();
        if (project == null || !project.isAccessible()) {
            return fs;
        }
        boolean isWar = J2EEProjectUtilities.isDynamicWebProject((IProject)project);
        boolean isEar = J2EEProjectUtilities.isEARProject((IProject)project);
        boolean isReferencedByEar = false;
        if (!isEar) {
            IProject[] ps = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
            int i = 0;
            while (i < ps.length) {
                fs.addAll(WebUtils.getFilesToTouch(ps[i]));
                isReferencedByEar = true;
                ++i;
            }
        }
        if (isEar && (f = project.getFile((path = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getProjectRelativePath()).append("META-INF").append("application.xml"))) != null && f.exists()) {
            fs.add(f);
        }
        if (isWar && !isReferencedByEar && (f = project.getFile((path = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getProjectRelativePath()).append("WEB-INF").append("web.xml"))) != null && f.exists()) {
            fs.add(f);
        }
        return fs;
    }
}

