/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.projecttemplates.JarVersionObserver;
import org.jboss.tools.common.projecttemplates.ProjectTemplatesPlugin;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.jst.web.WebPreference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WebModelPlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.jst.web";
    static WebModelPlugin instance;
    private static final String JAVA_BUILDER_ID = "org.eclipse.jdt.core.javabuilder";
    static boolean copiedJS;

    static {
        copiedJS = false;
    }

    public static WebModelPlugin getDefault() {
        if (instance == null) {
            Platform.getBundle((String)PLUGIN_ID);
        }
        return instance;
    }

    public static boolean isDebugEnabled() {
        return WebModelPlugin.getDefault().isDebugging();
    }

    public WebModelPlugin() {
        instance = this;
    }

    protected void initializeDefaultPluginPreferences() {
        super.initializeDefaultPluginPreferences();
        Properties p = new Properties();
        p.setProperty(XModelConstants.WORKSPACE, EclipseResourceUtil.getInstallPath((Plugin)this));
        p.setProperty("initialModel", "true");
        XModel initialModel = PreferenceModelUtilities.createPreferenceModel((Properties)p);
        if (initialModel != null) {
            for (Object preference : WebPreference.getPreferenceList()) {
                if (!(preference instanceof WebPreference)) continue;
                try {
                    PreferenceModelUtilities.initPreferenceValue((XModel)initialModel, (Preference)((WebPreference)((Object)preference)));
                }
                catch (XModelException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            PreferenceModelUtilities.getPreferenceModel().save();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProjectTemplatesPlugin.getDefault();
    }

    public static ILaunchConfiguration findLaunchConfig(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration launchConfiguration = launchConfigurations[i];
            if (launchConfiguration.getName().equals(name)) {
                return launchConfiguration;
            }
            ++i;
        }
        return null;
    }

    public static String getTemplateStateLocation() {
        return ProjectTemplatesPlugin.getTemplateStateLocation();
    }

    public static IPath getTemplateStatePath() {
        return ProjectTemplatesPlugin.getTemplateStatePath();
    }

    public static IPluginLog getPluginLog() {
        return WebModelPlugin.getDefault();
    }

    public static void addNatureToProjectWithValidationSupport(IProject project, String builderId, String natureId) throws CoreException {
        int oldWstIndex;
        EclipseResourceUtil.addNatureToProject((IProject)project, (String)natureId);
        IProjectDescription desc = project.getDescription();
        ICommand[] existing = desc.getBuildSpec();
        boolean updated = false;
        int javaBuilderIndex = -1;
        ICommand javaBuilder = null;
        int wstValidationBuilderIndex = -1;
        ICommand wstValidationBuilder = null;
        int builderIndex = -1;
        ICommand builder = null;
        int i = 0;
        while (i < existing.length) {
            if (JAVA_BUILDER_ID.equals(existing[i].getBuilderName())) {
                javaBuilderIndex = i;
                javaBuilder = existing[i];
            } else if ("org.eclipse.wst.validation.validationbuilder".equals(existing[i].getBuilderName())) {
                wstValidationBuilderIndex = i;
                wstValidationBuilder = existing[i];
            } else if (builderId.equals(existing[i].getBuilderName())) {
                builderIndex = i;
                builder = existing[i];
            }
            ++i;
        }
        if (javaBuilderIndex == -1) {
            WebModelPlugin.getDefault().logError("Can't enable " + builderId + " support on the project " + project.getName() + " without Java builder.");
            return;
        }
        if (wstValidationBuilderIndex != -1 && wstValidationBuilderIndex < javaBuilderIndex) {
            existing[javaBuilderIndex] = wstValidationBuilder;
            existing[wstValidationBuilderIndex] = javaBuilder;
            oldWstIndex = wstValidationBuilderIndex;
            wstValidationBuilderIndex = javaBuilderIndex;
            javaBuilderIndex = oldWstIndex;
            updated = true;
        }
        if (builderIndex == -1) {
            if (updated) {
                desc.setBuildSpec(existing);
                project.setDescription(desc, null);
                updated = false;
            }
            desc = project.getDescription();
            existing = desc.getBuildSpec();
            builderIndex = existing.length - 1;
            builder = WebModelPlugin.getBuilder(project, builderId);
        }
        if (wstValidationBuilderIndex == -1) {
            existing = WebModelPlugin.appendBuilder(project, existing, "org.eclipse.wst.validation.validationbuilder");
            wstValidationBuilderIndex = existing.length - 1;
            wstValidationBuilder = existing[wstValidationBuilderIndex];
            updated = true;
        }
        if (wstValidationBuilderIndex < builderIndex) {
            existing[wstValidationBuilderIndex] = builder;
            existing[builderIndex] = wstValidationBuilder;
            oldWstIndex = wstValidationBuilderIndex;
            wstValidationBuilderIndex = builderIndex;
            builderIndex = oldWstIndex;
            updated = true;
        }
        if (builderIndex < javaBuilderIndex) {
            existing[javaBuilderIndex] = builder;
            existing[builderIndex] = javaBuilder;
            int oldJavaIndex = javaBuilderIndex;
            javaBuilderIndex = builderIndex;
            builderIndex = oldJavaIndex;
            updated = true;
        }
        if (updated) {
            desc.setBuildSpec(existing);
            project.setDescription(desc, null);
        }
    }

    private static ICommand getBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] existing;
        IProjectDescription desc = project.getDescription();
        ICommand[] iCommandArray = existing = desc.getBuildSpec();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (builderId.equals(command.getBuilderName())) {
                return command;
            }
            ++n2;
        }
        return null;
    }

    private static ICommand[] appendBuilder(IProject project, ICommand[] commands, String builderId) throws CoreException {
        ICommand[] cmds = new ICommand[commands.length + 1];
        ICommand newcmd = project.getDescription().newCommand();
        newcmd.setBuilderName(builderId);
        cmds[commands.length] = newcmd;
        System.arraycopy(commands, 0, cmds, 0, commands.length);
        return cmds;
    }

    public static File getJSStateRoot() {
        if (!copiedJS) {
            copiedJS = true;
            try {
                WebModelPlugin.copyJS();
            }
            catch (IOException e) {
                WebModelPlugin.getDefault().logError(e);
            }
        }
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        return Platform.getStateLocation((Bundle)bundle).toFile();
    }

    static void copyJS() throws IOException {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        File location = Platform.getStateLocation((Bundle)bundle).toFile();
        File install = FileLocator.getBundleFile((Bundle)bundle);
        JarVersionObserver jarVersionObserver = new JarVersionObserver(location);
        if (install.isDirectory()) {
            WebModelPlugin.copy(location, install, "js");
        } else {
            UnzipOperation unzip = new UnzipOperation(install);
            unzip.execute(location, "js.*");
        }
        jarVersionObserver.execute();
    }

    private static void copy(File location, File install, String name) {
        location = new File(location, name);
        install = new File(install, name);
        location.mkdirs();
        FileUtil.copyDir((File)install, (File)location, (boolean)true, (boolean)true, (boolean)true, null);
    }
}

