/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JavaMigrationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;

public class RemoteDebugLaunchUtil {
    private static final String DEFAULT_REMOTE_JBOSS_APP = "Remote myapp";
    private static final String JBOSS_TEMP_JAVA_APPLICATION = "jbossTempJavaApplication";
    private static final String REMOTE_JAVA_APP_LAUNCH_TYPE_ID = "org.eclipse.jdt.launching.remoteJavaApplication";

    public static boolean isRemoteDebuggerConnected(String host, int port) {
        return RemoteDebugLaunchUtil.getExistingRemoteDebugLaunch(host, port) != null;
    }

    public static ILaunch getExistingRemoteDebugLaunch(String host, int port) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] all = manager.getLaunches();
        int i = 0;
        while (i < all.length) {
            if (!all[i].isTerminated()) {
                try {
                    Map m;
                    ILaunchConfiguration lc = all[i].getLaunchConfiguration();
                    String type = lc.getType().getIdentifier();
                    System.out.println(type);
                    if (type.equals(REMOTE_JAVA_APP_LAUNCH_TYPE_ID) && (m = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null)) != null) {
                        String h = (String)m.get("hostname");
                        String p = (String)m.get("port");
                        if (host.equals(h) && Integer.toString(port).equals(p)) {
                            return all[i];
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public static ILaunchConfiguration createTemporaryLaunchConfiguration(String projectName, String typeId) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateLaunchConfigurationName(JBOSS_TEMP_JAVA_APPLICATION));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        ILaunchConfiguration config = wc.doSave();
        return config;
    }

    public static ILaunchConfigurationWorkingCopy createNewLaunchConfiguration(ILaunchConfigurationType type) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateLaunchConfigurationName(DEFAULT_REMOTE_JBOSS_APP));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, RemoteDebugActivator.getDefaultVMConnector().getIdentifier());
        wc.setAttribute("JBossRemoteJavaApplication", true);
        return wc;
    }

    public static ILaunchConfiguration[] getLaunchConfigurations() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID);
        try {
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            ArrayList<ILaunchConfiguration> jbossConfigurations = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("JBossRemoteJavaApplication", false)) {
                    jbossConfigurations.add(config);
                }
                ++n2;
            }
            return jbossConfigurations.toArray(new ILaunchConfiguration[0]);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static ILaunchConfiguration getDefaultLaunchConfiguration() {
        ILaunchConfiguration[] configs = RemoteDebugLaunchUtil.getLaunchConfigurations();
        if (configs != null && configs.length > 0) {
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                boolean isDefault = false;
                try {
                    isDefault = config.getAttribute("setAsDefault", false);
                }
                catch (CoreException coreException) {}
                if (isDefault) {
                    return config;
                }
                ++n2;
            }
            if (configs.length == 1) {
                try {
                    ILaunchConfigurationWorkingCopy wc = configs[0].getWorkingCopy();
                    wc.setAttribute("setAsDefault", true);
                    wc.doSave();
                }
                catch (CoreException e) {
                    RemoteDebugActivator.pluginLog().logError((Throwable)e);
                }
            }
            return configs[0];
        }
        return null;
    }

    public static ILaunchConfiguration createOrGetDefaultLaunchConfiguration(String port, String host, IJavaProject javaProject, IJavaElement[] selection) throws CoreException {
        ILaunchConfiguration config = RemoteDebugActivator.getDefault().getDefaultLaunchConfiguration();
        ILaunchConfigurationWorkingCopy wc = null;
        if (config != null) {
            wc = config.getWorkingCopy();
            RemoteDebugLaunchUtil.setAttribute(wc, host, port);
            wc.doSave();
        } else {
            ILaunchConfigurationType configType = RemoteDebugLaunchUtil.getRemoteJavaApplicationConfigurationType();
            wc = RemoteDebugLaunchUtil.createNewLaunchConfiguration(configType);
        }
        if (javaProject != null && javaProject.isOpen()) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
            try {
                JavaMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)wc);
            }
            catch (CoreException ce) {
                RemoteDebugActivator.pluginLog().logError((Throwable)ce);
            }
        }
        RemoteDebugLaunchUtil.setAttribute(wc, host, port);
        if (selection != null) {
            RemoteDebugActivator.configureSourceLookup(wc, selection, javaProject);
        }
        config = wc.doSave();
        return config;
    }

    private static void setAttribute(ILaunchConfigurationWorkingCopy wc, String host, String port) {
        HashMap<String, String> attrMap = new HashMap<String, String>(2);
        attrMap.put("hostname", host);
        attrMap.put("port", port == null ? "" : port);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }

    public static ILaunchConfigurationType getRemoteJavaApplicationConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID);
        return type;
    }
}

