/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.job.LoadKeysJob;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AddSSHKeyWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.NewSSHKeyWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.SSHKeysWizardPageModel;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

class ManageSSHKeysWizardPage
extends AbstractOpenShiftWizardPage {
    private SSHKeysWizardPageModel pageModel;
    private TableViewer viewer;

    ManageSSHKeysWizardPage(ExpressConnection connection, IWizard wizard) {
        this(ExpressUIMessages.MANAGE_SSH_KEYS_WIZARD_PAGE, NLS.bind((String)ExpressUIMessages.MANAGE_SSH_KEYS_WIZARD_PAGE_DESCRIPTION, (Object)connection.getUsername()), "ManageSSHKeysPage", connection, wizard);
    }

    ManageSSHKeysWizardPage(String title, String description, String pageName, ExpressConnection connection, IWizard wizard) {
        super(title, description, pageName, wizard);
        this.pageModel = new SSHKeysWizardPageModel(connection);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group sshKeysGroup = new Group(parent, 0);
        sshKeysGroup.setText(ExpressUIMessages.SSH_PUBLIC_KEYS_GROUP);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)sshKeysGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)sshKeysGroup);
        Composite tableContainer = new Composite((Composite)sshKeysGroup, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(BeanProperties.value((String)"selectedSSHKey").observe((Object)this.pageModel)).in(dbc);
        Button addExistingButton = new Button((Composite)sshKeysGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)addExistingButton);
        addExistingButton.setText(ExpressUIMessages.ADD_EXISTING_BUTTON);
        addExistingButton.addSelectionListener(this.onAddExisting());
        Button addNewButton = new Button((Composite)sshKeysGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)addNewButton);
        addNewButton.setText(ExpressUIMessages.NEW_BUTTON);
        addNewButton.addSelectionListener(this.onAddNew());
        Button removeButton = new Button((Composite)sshKeysGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText(ExpressUIMessages.REMOVE_BUTTON);
        removeButton.addSelectionListener(this.onRemove());
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).to((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Composite filler = new Composite((Composite)sshKeysGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)filler);
        Button refreshButton = new Button((Composite)sshKeysGroup, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000008).applyTo((Control)refreshButton);
        refreshButton.setText(ExpressUIMessages.REFRESH_BUTTON);
        refreshButton.addSelectionListener(this.onRefresh());
        Link sshPrefsLink = new Link(parent, 0);
        sshPrefsLink.setText(ExpressUIMessages.SSH_PREFS_LINK);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sshPrefsLink);
        sshPrefsLink.addSelectionListener((SelectionListener)this.onSshPrefs());
    }

    private SelectionListener onRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String keyName = ManageSSHKeysWizardPage.this.pageModel.getSelectedSSHKey().getName();
                if (MessageDialog.openConfirm((Shell)ManageSSHKeysWizardPage.this.getShell(), (String)ExpressUIMessages.REMOVE_SSH_KEY_DIALOG_TITLE, (String)NLS.bind((String)ExpressUIMessages.REMOVE_SSH_KEY_QUESTION, (Object)keyName))) {
                    try {
                        IStatus status = WizardUtils.runInWizard((Job)new JobChainBuilder((Job)new RemoveKeyJob()).runWhenDone((Job)new RefreshViewerJob()).build(), (IWizardContainer)ManageSSHKeysWizardPage.this.getContainer(), (DataBindingContext)ManageSSHKeysWizardPage.this.getDatabindingContext());
                        if (status.equals(4)) {
                            ManageSSHKeysWizardPage.this.setErrorMessage(status.getMessage());
                        } else {
                            ManageSSHKeysWizardPage.this.setErrorMessage(null);
                        }
                    }
                    catch (Exception ex) {
                        ManageSSHKeysWizardPage.this.setErrorMessage(ex.getMessage());
                        StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus(NLS.bind((String)ExpressUIMessages.COULD_NOT_REMOVE_SSH_KEY, (Object)keyName), ex), 1);
                    }
                }
            }
        };
    }

    private SelectionListener onAddExisting() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSSHKeyWizard wizard = new AddSSHKeyWizard(ManageSSHKeysWizardPage.this.pageModel.getConnection());
                if (WizardUtils.openWizardDialog((IWizard)wizard, (Shell)ManageSSHKeysWizardPage.this.getShell()) == 1) {
                    return;
                }
                try {
                    WizardUtils.runInWizard((Job)new RefreshViewerJob(), (IWizardContainer)ManageSSHKeysWizardPage.this.getContainer(), (DataBindingContext)ManageSSHKeysWizardPage.this.getDatabindingContext());
                    ManageSSHKeysWizardPage.this.pageModel.setSelectedSSHKey(wizard.getSSHKey());
                }
                catch (Exception ex) {
                    ManageSSHKeysWizardPage.this.setErrorMessage(ex.getMessage());
                    StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_REFRESH_VIEWER, ex), 1);
                }
            }
        };
    }

    private SelectionListener onAddNew() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSSHKeyWizard wizard = new NewSSHKeyWizard(ManageSSHKeysWizardPage.this.pageModel.getConnection());
                if (WizardUtils.openWizardDialog((IWizard)wizard, (Shell)ManageSSHKeysWizardPage.this.getShell()) == 1) {
                    return;
                }
                try {
                    WizardUtils.runInWizard((Job)new RefreshViewerJob(), (IWizardContainer)ManageSSHKeysWizardPage.this.getContainer(), (DataBindingContext)ManageSSHKeysWizardPage.this.getDatabindingContext());
                    ManageSSHKeysWizardPage.this.pageModel.setSelectedSSHKey(wizard.getSSHKey());
                }
                catch (Exception ex) {
                    ManageSSHKeysWizardPage.this.setErrorMessage(ex.getMessage());
                    StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_REFRESH_VIEWER, ex), 1);
                }
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IOpenShiftSSHKey>(){

            public String getValue(IOpenShiftSSHKey key) {
                return key.getName();
            }
        }).name("Name").align(16384).weight(2).minWidth(200).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IOpenShiftSSHKey>(){

            public String getValue(IOpenShiftSSHKey key) {
                return key.getKeyType().getTypeId();
            }
        }).name("Type").align(16384).weight(1).minWidth(50).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IOpenShiftSSHKey>(){

            public String getValue(IOpenShiftSSHKey key) {
                return StringUtils.shorten((String)key.getPublicKey(), (int)24);
            }
        }).name("Content").align(16384).weight(4).minWidth(100).buildColumn().buildViewer();
        return this.viewer;
    }

    protected void onPageActivated(DataBindingContext dbc) {
        try {
            LoadKeysJob loadKeysJob = new LoadKeysJob(this.pageModel.getConnection());
            new JobChainBuilder((Job)loadKeysJob).runWhenSuccessfullyDone((Job)new RefreshViewerJob());
            WizardUtils.runInWizard((Job)loadKeysJob, (IWizardContainer)this.getContainer());
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_LOAD_SSH_KEYS, e), 1);
        }
    }

    private SelectionListener onRefresh() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RefreshKeysJob refreshKeysJob = new RefreshKeysJob();
                    new JobChainBuilder((Job)refreshKeysJob).runWhenDone((Job)new RefreshViewerJob());
                    IStatus status = WizardUtils.runInWizard((Job)refreshKeysJob, (IWizardContainer)ManageSSHKeysWizardPage.this.getContainer(), (DataBindingContext)ManageSSHKeysWizardPage.this.getDatabindingContext());
                    if (status.equals(4)) {
                        ManageSSHKeysWizardPage.this.setErrorMessage(status.getMessage());
                    } else {
                        ManageSSHKeysWizardPage.this.setErrorMessage(null);
                    }
                }
                catch (Exception ex) {
                    ManageSSHKeysWizardPage.this.setErrorMessage(ex.getMessage());
                    StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_REFRESH_SSH_KEYS, ex), 1);
                }
            }
        };
    }

    private SelectionAdapter onSshPrefs() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHUtils.openPreferencesPage(ManageSSHKeysWizardPage.this.getShell());
            }
        };
    }

    protected SSHKeysWizardPageModel getPageModel() {
        return this.pageModel;
    }

    private class RefreshKeysJob
    extends Job {
        private RefreshKeysJob() {
            super(ExpressUIMessages.REFRESH_SSH_KEYS_JOB);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ManageSSHKeysWizardPage.this.pageModel.refresh();
                return Status.OK_STATUS;
            }
            catch (OpenShiftException ex) {
                return ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_REFRESH_SSH_KEYS, ex);
            }
        }
    }

    private class RefreshViewerJob
    extends UIJob {
        public RefreshViewerJob() {
            super(ExpressUIMessages.REFRESH_VIEWER_JOB);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                IOpenShiftSSHKey key = ManageSSHKeysWizardPage.this.pageModel.getSelectedSSHKey();
                ManageSSHKeysWizardPage.this.viewer.setInput(ManageSSHKeysWizardPage.this.pageModel.getSSHKeys());
                if (key != null) {
                    ManageSSHKeysWizardPage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)key), true);
                }
                ManageSSHKeysWizardPage.this.setErrorMessage(null);
                return Status.OK_STATUS;
            }
            catch (OpenShiftException ex) {
                ManageSSHKeysWizardPage.this.setErrorMessage(ex.getMessage());
                return ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_REFRESH_VIEWER, ex);
            }
        }
    }

    private class RemoveKeyJob
    extends Job {
        private RemoveKeyJob() {
            super(NLS.bind((String)ExpressUIMessages.REMOVE_SSH_KEY_JOB, (Object)ManageSSHKeysWizardPage.this.pageModel.getSelectedSSHKey().getName()));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ManageSSHKeysWizardPage.this.pageModel.removeKey();
                return Status.OK_STATUS;
            }
            catch (OpenShiftException ex) {
                return ExpressUIActivator.createErrorStatus(NLS.bind((String)ExpressUIMessages.COULD_NOT_REMOVE_SSH_KEY, (Object)ManageSSHKeysWizardPage.this.pageModel.getSelectedSSHKey().getName()), ex);
            }
        }
    }
}

