/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AddSSHKeyJob;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AddSSHKeyWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.databinding.SSHPublicKeyNameValidator;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.databinding.SSHPublicKeyValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class AddSSHKeyWizardPage
extends AbstractOpenShiftWizardPage {
    private static final String FILTEREXPRESSION_PUBLIC_SSH_KEY = "*.pub";
    private static final String FILTERNAME_PUBLIC_SSH_KEY = "Public ssh key file (*.pub)";
    private AddSSHKeyWizardPageModel pageModel;

    public AddSSHKeyWizardPage(ExpressConnection user, IWizard wizard) {
        super("Add existing SSH Key", "Add an exiting SSH key to your OpenShift user " + user.getUsername(), "AddSSHKeysPage", wizard);
        this.pageModel = new AddSSHKeyWizardPageModel(user);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group addSSHKeyGroup = new Group(parent, 0);
        addSSHKeyGroup.setText("Add existing SSH Key");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)addSSHKeyGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo((Composite)addSSHKeyGroup);
        Label nameLabel = new Label((Composite)addSSHKeyGroup, 0);
        nameLabel.setText("Name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        Text nameText = new Text((Composite)addSSHKeyGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)nameText);
        Binding nameBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText)).validatingAfterConvert((IValidator)new SSHPublicKeyNameValidator(this.pageModel))).to(BeanProperties.value((String)"name").observe((Object)this.pageModel)).notUpdatingParticipant()).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label publicKeyLabel = new Label((Composite)addSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)publicKeyLabel);
        publicKeyLabel.setText("Public Key:");
        Text publicKeyText = new Text((Composite)addSSHKeyGroup, 2048);
        publicKeyText.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)publicKeyText);
        ISWTObservableValue publicKeyObservable = WidgetProperties.text((int)24).observe((Widget)publicKeyText);
        ValueBindingBuilder.bind((IObservableValue)publicKeyObservable).to(BeanProperties.value((String)"publicKeyPath").observe((Object)this.pageModel)).in(dbc);
        Button browseButton = new Button((Composite)addSSHKeyGroup, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener(this.onBrowse());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)browseButton);
        SSHPublicKeyValidator sshPublicKeyValidator = new SSHPublicKeyValidator((IObservableValue)publicKeyObservable, this.pageModel);
        dbc.addValidationStatusProvider((ValidationStatusProvider)sshPublicKeyValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)sshPublicKeyValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Link sshPrefsLink = new Link(parent, 0);
        sshPrefsLink.setText("Please make sure that your private key for this public key is listed in the\n<a>SSH2 Preferences</a>");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sshPrefsLink);
        sshPrefsLink.addSelectionListener((SelectionListener)this.onSshPrefs(sshPublicKeyValidator));
    }

    private SelectionListener onBrowse() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AddSSHKeyWizardPage.this.getShell(), 4096);
                dialog.setFilterPath(SSHUtils.getSSH2Home());
                dialog.setFilterExtensions(new String[]{AddSSHKeyWizardPage.FILTEREXPRESSION_PUBLIC_SSH_KEY});
                dialog.setFilterNames(new String[]{AddSSHKeyWizardPage.FILTERNAME_PUBLIC_SSH_KEY});
                String filePath = null;
                filePath = dialog.open();
                if (filePath != null) {
                    AddSSHKeyWizardPage.this.pageModel.setPublicKeyPath(filePath);
                }
            }
        };
    }

    private SelectionAdapter onSshPrefs(final SSHPublicKeyValidator sshPublicKeyValidator) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHUtils.openPreferencesPage(AddSSHKeyWizardPage.this.getShell());
                sshPublicKeyValidator.forceRevalidate();
            }
        };
    }

    public IStatus addConfiguredSSHKey() {
        try {
            return WizardUtils.runInWizard((Job)new AddSSHKeyJob(this.pageModel), (IWizardContainer)this.getContainer());
        }
        catch (Exception exception) {
            return ExpressUIActivator.createErrorStatus("Could not add ssh key " + this.pageModel.getName() + ".");
        }
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    public IOpenShiftSSHKey getSSHKey() {
        return this.pageModel.getSSHKey();
    }
}

