/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.connection;

import org.apache.commons.lang.BooleanUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnectionFactory;
import org.jboss.tools.openshift.internal.common.ui.connection.BaseConnectionEditor;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;

public class ExpressConnectionEditor
extends BaseConnectionEditor {
    private Text usernameText;
    private IObservableValue usernameObservable;
    private Binding usernameBinding;
    private Text passwordText;
    private IObservableValue passwordObservable;
    private Binding passwordBinding;
    private IObservableValue rememberPasswordObservable;
    private Button rememberPasswordCheckBox;
    private Binding rememberPasswordBinding;

    public Composite createControls(Composite parent, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(composite);
        Label rhLoginLabel = new Label(composite, 0);
        rhLoginLabel.setText("&Username:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)rhLoginLabel);
        this.usernameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.usernameText);
        this.usernameObservable = new WritableValue(null, String.class);
        this.usernameObservable.addValueChangeListener(this.changeListener);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passwordLabel);
        this.passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.passwordText);
        this.passwordObservable = new WritableValue(null, String.class);
        this.passwordObservable.addValueChangeListener(this.changeListener);
        this.rememberPasswordCheckBox = new Button(composite, 32);
        this.rememberPasswordCheckBox.setText("&Save Password (could trigger secure storage login)");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.rememberPasswordCheckBox);
        this.rememberPasswordObservable = new WritableValue(null, Boolean.class);
        this.rememberPasswordObservable.addValueChangeListener(this.changeListener);
        return composite;
    }

    public void onVisible(IObservableValue detailViewModel, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.bindWidgetsToInternalModel(detailViewModel, dbc);
        this.updateFrom(this.selectedConnection);
    }

    private void bindWidgetsToInternalModel(IObservableValue detailViewModel, DataBindingContext dbc) {
        this.usernameBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.usernameText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new RequiredStringValidator("username"))).to(this.usernameObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.usernameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        this.passwordBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.passwordText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new RequiredStringValidator("password"))).to(this.passwordObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.passwordBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        this.rememberPasswordBinding = ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)this.rememberPasswordCheckBox)).to(this.rememberPasswordObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.rememberPasswordBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
    }

    public void onInVisible(IObservableValue detailViewModel, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.disposeBindings();
    }

    protected void onSelectedConnectionChanged(IObservableValue selectedConnection) {
        this.updateFrom(selectedConnection);
    }

    private void updateFrom(IObservableValue selectedConnectionObservable) {
        if (selectedConnectionObservable.getValue() instanceof ExpressConnection) {
            ExpressConnection selectedConnection = (ExpressConnection)selectedConnectionObservable.getValue();
            this.usernameObservable.setValue((Object)selectedConnection.getUsername());
            this.passwordObservable.setValue((Object)selectedConnection.getPassword());
            this.rememberPasswordObservable.setValue((Object)selectedConnection.isRememberPassword());
        } else if (selectedConnectionObservable.getValue() instanceof NewConnectionMarker) {
            this.usernameObservable.setValue(null);
            this.passwordObservable.setValue(null);
            this.rememberPasswordObservable.setValue((Object)false);
        }
    }

    public boolean isViewFor(Object object) {
        return object instanceof ExpressConnectionFactory;
    }

    public void dispose() {
        this.disposeBindings();
    }

    private void disposeBindings() {
        DataBindingUtils.dispose((ValidationStatusProvider)this.usernameBinding);
        DataBindingUtils.dispose((ValidationStatusProvider)this.passwordBinding);
        DataBindingUtils.dispose((ValidationStatusProvider)this.rememberPasswordBinding);
    }

    protected ConnectionWizardPageModel.IConnectionAuthenticationProvider createConnectionAuthenticationProvider(ConnectionWizardPageModel pageModel) {
        return new ExpressConnectionAuthenticationProvider();
    }

    private class ExpressConnectionAuthenticationProvider
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private ExpressConnectionAuthenticationProvider() {
        }

        public IConnection update(IConnection connection) {
            Assert.isLegal((boolean)(connection instanceof ExpressConnection));
            final ExpressConnection expressConnection = (ExpressConnection)connection;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    expressConnection.setUsername((String)ExpressConnectionEditor.this.usernameObservable.getValue());
                    expressConnection.setPassword((String)ExpressConnectionEditor.this.passwordObservable.getValue());
                    expressConnection.setRememberPassword(BooleanUtils.toBoolean((Boolean)((Boolean)ExpressConnectionEditor.this.rememberPasswordObservable.getValue())));
                }
            });
            return expressConnection;
        }
    }
}

