/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.template;

import com.openshift.client.IQuickstart;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.AlternativeCartridges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.CollectionUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.AbstractApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IQuickstartApplicationTemplate;

public class QuickstartApplicationTemplate
extends AbstractApplicationTemplate
implements IQuickstartApplicationTemplate {
    private IQuickstart quickstart;
    private Set<ICartridge> cartridges;

    public QuickstartApplicationTemplate(IQuickstart quickstart) {
        super(quickstart.getName(), quickstart.getSummary(), new IApplicationTemplate[0]);
        this.quickstart = quickstart;
        this.cartridges = this.getFirstAlternatives(quickstart.getSuitableCartridges());
    }

    @Override
    public IQuickstart getQuickstart() {
        return this.quickstart;
    }

    @Override
    public String getLanguage() {
        return this.quickstart.getLanguage();
    }

    @Override
    public String getPageUrl() {
        String href = this.quickstart.getHref();
        if (StringUtils.isEmpty((String)href)) {
            href = this.quickstart.getWebsite();
        }
        return href;
    }

    @Override
    public boolean hasPageUrl() {
        return !StringUtils.isEmpty((String)this.getPageUrl());
    }

    @Override
    public String getInitialGitUrl() {
        return this.quickstart.getInitialGitUrl();
    }

    @Override
    public List<ICartridge> getAlternativesFor(ICartridge cartridge) {
        return this.quickstart.getAlternativesFor(cartridge);
    }

    @Override
    public Set<ICartridge> getAllCartridges() {
        return this.cartridges;
    }

    protected HashSet<ICartridge> getFirstAlternatives(List<AlternativeCartridges> allAlternatives) {
        HashSet<ICartridge> cartridges = new HashSet<ICartridge>();
        for (AlternativeCartridges alternatives : allAlternatives) {
            ICartridge firstAlternative = (ICartridge)CollectionUtils.getFirstElement((Collection)alternatives.get());
            if (firstAlternative == null) continue;
            cartridges.add(firstAlternative);
        }
        return cartridges;
    }

    @Override
    public Set<ICartridge> getEmbeddedCartridges() {
        return this.getAllCartridges();
    }

    @Override
    public String getName() {
        return super.getName() + " (Quickstart)";
    }

    @Override
    public List<String> getTags() {
        if (this.quickstart == null) {
            return Collections.emptyList();
        }
        return this.quickstart.getTags();
    }

    @Override
    public String getTagsString() {
        return StringUtils.toString(this.getTags());
    }

    @Override
    public boolean isOpenShiftMaintained() {
        return "openshift".equals(StringUtils.toLowerCase((String)this.quickstart.getProvider()));
    }

    @Override
    public boolean isAutomaticSecurityUpdates() {
        return StringUtils.isEmpty((String)this.quickstart.getInitialGitUrl());
    }

    @Override
    public boolean isMatching(String expression) {
        boolean matching = super.isMatching(expression);
        if (matching) {
            return true;
        }
        return this.isMatchingTag(StringUtils.toLowerCase((String)expression));
    }

    private boolean isMatchingTag(String expression) {
        for (String tag : this.quickstart.getTags()) {
            if (!this.isMatching(expression, tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddRemoveCartridges() {
        return false;
    }

    @Override
    public boolean isInitialGitUrlEditable() {
        return false;
    }

    @Override
    public boolean isCodeAnything() {
        return false;
    }
}

