/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.template;

import com.openshift.client.cartridge.ICartridge;
import java.util.Collections;
import java.util.Set;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;

public abstract class AbstractApplicationTemplate
extends ObservablePojo
implements IApplicationTemplate {
    private String name;
    private String description;

    protected AbstractApplicationTemplate(String name, String description, IApplicationTemplate ... children) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<ICartridge> getAllCartridges() {
        return Collections.emptySet();
    }

    @Override
    public Set<ICartridge> getEmbeddedCartridges() {
        return Collections.emptySet();
    }

    @Override
    public ICartridge getStandaloneCartridge() {
        return null;
    }

    @Override
    public String getInitialGitUrl() {
        return null;
    }

    @Override
    public boolean isMatching(String expression) {
        if (StringUtils.isEmpty((String)expression)) {
            return true;
        }
        String lowerCaseExpression = StringUtils.toLowerCase((String)expression);
        return this.isMatching(lowerCaseExpression, StringUtils.toLowerCase((String)this.getName())) || this.isMatching(lowerCaseExpression, StringUtils.toLowerCase((String)this.getDescription()));
    }

    protected boolean isMatching(String expression, String toMatch) {
        if (StringUtils.isEmpty((String)toMatch)) {
            return false;
        }
        return toMatch.indexOf(expression) >= 0;
    }

    @Override
    public boolean canCreateApplication() {
        return true;
    }
}

