/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.server;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.NotFoundOpenShiftException;
import com.openshift.client.OpenShiftException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.core.util.RegExUtils;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.server.BehaviorTaskModelUtil;
import org.jboss.tools.openshift.express.internal.ui.viewer.ApplicationColumnLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.viewer.DomainColumnLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ExpressApplicationWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ImportExpressApplicationWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.NewExpressApplicationWizard;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionColumLabelProvider;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizard;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class OpenShiftServerWizardComposite {
    protected IDeploymentTypeUI.IServerModeUICallback callback;
    private Composite composite;
    private Link importLink;
    private ComboViewer connectionComboViewer;
    private ComboViewer domainComboViewer;
    private ComboViewer applicationComboViewer;
    private ComboViewer deployProjectComboViewer;
    protected Text remoteText;
    protected Text deployFolderText;
    protected Button browseDeployFolderButton;
    private String remote;
    private String deployFolder;
    private IProject deployProject;
    private IDomain domain;
    private IApplication application;
    private ExpressConnection connection;
    private List<IDomain> domains;
    private List<IApplication> applications;
    private IServerWorkingCopy server;
    private Map<IApplication, IProject[]> projectsByApplication = new HashMap<IApplication, IProject[]>();

    public OpenShiftServerWizardComposite(Composite container, IDeploymentTypeUI.IServerModeUICallback callback) {
        this.callback = callback;
        this.server = callback.getServer();
        this.composite = container;
        this.initModel(callback, (IServerAttributes)this.server);
        this.createWidgets(container);
        this.initWidgets();
    }

    public Composite getComposite() {
        return this.composite;
    }

    private void initModel(IDeploymentTypeUI.IServerModeUICallback callback, IServerAttributes server) {
        IApplication application = BehaviorTaskModelUtil.getApplication(callback);
        IDomain domain = BehaviorTaskModelUtil.getDomain(callback);
        this.updateModel(this.getConnection(callback), domain, application);
    }

    private ExpressConnection getConnection(IDeploymentTypeUI.IServerModeUICallback callback) {
        ExpressConnection connection = BehaviorTaskModelUtil.getConnection(callback);
        if (connection == null) {
            connection = (ExpressConnection)ConnectionsRegistrySingleton.getInstance().getRecentConnection(ExpressConnection.class);
        }
        return connection;
    }

    protected String getDeployFolder(IApplication application, IProject deployProject) {
        if (application == null) {
            return null;
        }
        if (!ProjectUtils.isAccessible((IProject)deployProject)) {
            return null;
        }
        return OpenShiftServerUtils.getDefaultDeployFolder((IApplication)application);
    }

    private void initWidgets() {
        this.connectionComboViewer.setInput((Object)ConnectionsRegistrySingleton.getInstance().getAll());
        this.selectConnectionCombo(this.connection);
        this.domainComboViewer.setInput(this.domains);
        this.selectDomainCombo(this.domain);
        this.applicationComboViewer.setInput(this.applications);
        this.selectApplicationCombo(this.application);
        this.setDeployProjectCombo(this.application, this.projectsByApplication);
        this.remoteText.setText(StringUtils.null2emptyString((String)this.remote));
        this.deployFolderText.setText(StringUtils.null2emptyString((String)this.deployFolder));
    }

    private void createWidgets(Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(composite);
        Label connectionLabel = new Label(composite, 0);
        connectionLabel.setText(ExpressUIMessages.OpenShiftServerWizardConnection);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)connectionLabel);
        Combo connectionCombo = new Combo(composite, -1);
        this.connectionComboViewer = new ComboViewer(connectionCombo);
        this.connectionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.connectionComboViewer.setLabelProvider((IBaseLabelProvider)new ConnectionColumLabelProvider());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)connectionCombo);
        this.connectionComboViewer.addSelectionChangedListener(this.onSelectConnection());
        Button newConnectionButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)newConnectionButton);
        newConnectionButton.setText(ExpressUIMessages.OpenShiftServerWizardNew);
        newConnectionButton.addSelectionListener(this.onNewConnection());
        Label domainNameLabel = new Label(composite, 0);
        domainNameLabel.setText(ExpressUIMessages.OpenShiftServerWizardDomainName);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)domainNameLabel);
        this.domainComboViewer = new ComboViewer(new Combo(composite, -1));
        this.domainComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.domainComboViewer.setLabelProvider((IBaseLabelProvider)new DomainColumnLabelProvider());
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).applyTo(this.domainComboViewer.getControl());
        this.domainComboViewer.addSelectionChangedListener(this.onSelectDomain());
        Label appNameLabel = new Label(composite, 0);
        appNameLabel.setText(ExpressUIMessages.OpenShiftServerWizardApplicationName);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)appNameLabel);
        this.applicationComboViewer = new ComboViewer(new Combo(composite, -1));
        this.applicationComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.applicationComboViewer.setLabelProvider((IBaseLabelProvider)new ApplicationColumnLabelProvider());
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).applyTo(this.applicationComboViewer.getControl());
        this.applicationComboViewer.addSelectionChangedListener(this.onSelectApplication());
        Label deployLocationLabel = new Label(composite, 0);
        this.deployProjectComboViewer = new ComboViewer(new Combo(composite, -1));
        this.deployProjectComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.deployProjectComboViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IProject)) {
                    return super.getText(element);
                }
                return ((IProject)element).getName();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).applyTo(this.deployProjectComboViewer.getControl());
        deployLocationLabel.setText(ExpressUIMessages.OpenShiftServerWizardDeployProject);
        this.deployProjectComboViewer.addSelectionChangedListener(this.onSelectDeployProject());
        this.importLink = new Link(composite, 0);
        this.importLink.setText(ExpressUIMessages.OpenShiftServerWizardImportLink);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.importLink);
        this.importLink.addSelectionListener((SelectionListener)this.onClickCreateOrImport());
        Label remoteLabel = new Label(composite, 0);
        remoteLabel.setText(ExpressUIMessages.OpenShiftServerWizardRemote);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)remoteLabel);
        this.remoteText = new Text(composite, 2052);
        this.remoteText.setEditable(false);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).applyTo((Control)this.remoteText);
        this.remoteText.addModifyListener(this.onModifyRemote());
        Group projectSettings = new Group(composite, 0);
        projectSettings.setText(ExpressUIMessages.OpenShiftServerWizardProjectSettings);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, false).applyTo((Control)projectSettings);
        projectSettings.setLayout((Layout)new GridLayout(2, false));
        Label zipDestLabel = new Label((Composite)projectSettings, 0);
        zipDestLabel.setText(ExpressUIMessages.OpenShiftServerWizardOutputDirectory);
        Composite zipDestComposite = new Composite((Composite)projectSettings, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)zipDestComposite);
        zipDestComposite.setLayout((Layout)new FormLayout());
        this.browseDeployFolderButton = new Button(zipDestComposite, 8);
        this.browseDeployFolderButton.setText(ExpressUIMessages.OpenShiftServerWizardBrowse);
        this.browseDeployFolderButton.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, (Object)100, (int)-5, null, (int)0, (Object)100, (int)0));
        this.browseDeployFolderButton.addSelectionListener((SelectionListener)this.onBrowseDeployFolder());
        this.deployFolderText = new Text(zipDestComposite, 2052);
        this.deployFolderText.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, (Object)100, (int)-5, (Object)0, (int)0, (Object)this.browseDeployFolderButton, (int)-5));
        this.deployFolderText.addModifyListener(this.onModifyDeployFolder());
    }

    private SelectionListener onNewConnection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressConnection connection = (ExpressConnection)UIUtils.getFirstElement((ISelection)OpenShiftServerWizardComposite.this.connectionComboViewer.getSelection(), ExpressConnection.class);
                ConnectionWizard wizard = new ConnectionWizard((IConnection)connection);
                if (WizardUtils.openWizardDialog((IWizard)wizard, (Shell)OpenShiftServerWizardComposite.this.connectionComboViewer.getControl().getShell()) == 0) {
                    OpenShiftServerWizardComposite.this.connectionComboViewer.getControl().setEnabled(true);
                    OpenShiftServerWizardComposite.this.connectionComboViewer.setInput((Object)ConnectionsRegistrySingleton.getInstance().getAll());
                    ExpressConnection selectedConnection = (ExpressConnection)ConnectionsRegistrySingleton.getInstance().getRecentConnection(ExpressConnection.class);
                    OpenShiftServerWizardComposite.this.selectConnectionCombo(selectedConnection);
                }
            }
        };
    }

    private ISelectionChangedListener onSelectConnection() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExpressConnection selectedConnection = (ExpressConnection)UIUtils.getFirstElement((ISelection)event.getSelection(), ExpressConnection.class);
                if (selectedConnection == null || selectedConnection.equals((Object)OpenShiftServerWizardComposite.this.connection)) {
                    return;
                }
                OpenShiftServerWizardComposite.this.callback.executeLongRunning((Job)new UpdateModelJob(selectedConnection, OpenShiftServerWizardComposite.this.domain, OpenShiftServerWizardComposite.this.getFirstApplication(OpenShiftServerWizardComposite.this.applications)));
                OpenShiftServerWizardComposite.this.updateWidgets();
            }
        };
    }

    protected ModifyListener onModifyDeployFolder() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerWizardComposite.this.deployFolder = OpenShiftServerWizardComposite.this.deployFolderText.getText();
            }
        };
    }

    protected ModifyListener onModifyRemote() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerWizardComposite.this.remote = OpenShiftServerWizardComposite.this.remoteText.getText();
            }
        };
    }

    protected SelectionAdapter onClickCreateOrImport() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressApplicationWizard wizard = null;
                wizard = OpenShiftServerWizardComposite.this.application != null ? new ImportExpressApplicationWizard(OpenShiftServerWizardComposite.this.connection, OpenShiftServerWizardComposite.this.application) : new NewExpressApplicationWizard(OpenShiftServerWizardComposite.this.connection);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.create();
                int success = dialog.open();
                if (success == 0 && wizard.isCreateServerAdapter()) {
                    OpenShiftServerWizardComposite.this.closeWizard(OpenShiftServerWizardComposite.this.callback);
                } else {
                    OpenShiftServerWizardComposite.this.projectsByApplication = OpenShiftServerWizardComposite.this.createProjectsByApplication(OpenShiftServerWizardComposite.this.applications);
                    OpenShiftServerWizardComposite.this.setDeployProjectCombo(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.projectsByApplication);
                    OpenShiftServerWizardComposite.this.updateCreateOrImportLink();
                    OpenShiftServerWizardComposite.this.updateErrorMessage(null);
                }
            }
        };
    }

    private void closeWizard(IDeploymentTypeUI.IServerModeUICallback callback) {
        if (!(callback instanceof DeploymentTypeUIUtil.NewServerWizardBehaviourCallback)) {
            return;
        }
        DeploymentTypeUIUtil.NewServerWizardBehaviourCallback behaviourCallback = (DeploymentTypeUIUtil.NewServerWizardBehaviourCallback)callback;
        IWizardHandle handle = behaviourCallback.getHandle();
        if (!(handle instanceof IWizardPage)) {
            return;
        }
        IWizard wizard = ((IWizardPage)handle).getWizard();
        WizardUtils.close((IWizard)wizard);
    }

    private ISelectionChangedListener onSelectDeployProject() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenShiftServerWizardComposite.this.deployProject = (IProject)UIUtils.getFirstElement((ISelection)event.getSelection(), IProject.class);
                OpenShiftServerWizardComposite.this.setRemoteText(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.deployProject);
                OpenShiftServerWizardComposite.this.setDeploymentFolderText(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.deployProject);
            }
        };
    }

    private ISelectionChangedListener onSelectDomain() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDomain selectedDomain = (IDomain)UIUtils.getFirstElement((ISelection)event.getSelection(), IDomain.class);
                if (selectedDomain == null || selectedDomain.equals(OpenShiftServerWizardComposite.this.domain)) {
                    return;
                }
                OpenShiftServerWizardComposite.this.callback.executeLongRunning((Job)new UpdateModelJob(OpenShiftServerWizardComposite.this.connection, selectedDomain, OpenShiftServerWizardComposite.this.application));
                OpenShiftServerWizardComposite.this.updateWidgets();
            }
        };
    }

    private ISelectionChangedListener onSelectApplication() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenShiftServerWizardComposite.this.application = (IApplication)UIUtils.getFirstElement((ISelection)event.getSelection(), IApplication.class);
                OpenShiftServerWizardComposite.this.setDeployProjectCombo(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.projectsByApplication);
                OpenShiftServerWizardComposite.this.updateCreateOrImportLink();
                OpenShiftServerWizardComposite.this.setDeploymentFolderText(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.deployProject);
                OpenShiftServerWizardComposite.this.setRemoteText(OpenShiftServerWizardComposite.this.application, OpenShiftServerWizardComposite.this.deployProject);
                OpenShiftServerWizardComposite.this.updateErrorMessage(null);
            }
        };
    }

    private String getRemote(IApplication application, IProject project) {
        RemoteConfig remoteConfig;
        block6: {
            Repository repository;
            block5: {
                if (application == null || project == null || !ProjectUtils.isAccessible((IProject)project)) {
                    return null;
                }
                try {
                    repository = EGitUtils.getRepository((IProject)project);
                    if (repository != null) break block5;
                    return null;
                }
                catch (CoreException e) {
                    ExpressUIActivator.log(NLS.bind((String)ExpressUIMessages.OpenShiftServerWizardCouldNotGetRemotePointing, (Object)application.getGitUrl(), (Object)project.getName()), e);
                    return null;
                }
            }
            Pattern gitURIPattern = Pattern.compile(RegExUtils.escapeRegex((String)application.getGitUrl()));
            remoteConfig = EGitUtils.getRemoteByUrl((Pattern)gitURIPattern, (Repository)repository);
            if (remoteConfig != null) break block6;
            return null;
        }
        return remoteConfig.getName();
    }

    private SelectionAdapter onBrowseDeployFolder() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolder f = OpenShiftServerWizardComposite.this.chooseFolder();
                if (f != null) {
                    OpenShiftServerWizardComposite.this.deployFolderText.setText(f.getFullPath().removeFirstSegments(1).makeRelative().toOSString());
                }
            }
        };
    }

    private IFolder chooseFolder() {
        if (this.deployProject == null) {
            return null;
        }
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(ExpressUIMessages.OpenShiftServerWizardDeployLocation);
        dialog.setMessage(ExpressUIMessages.OpenShiftServerWizardPleaseChooseLocation);
        dialog.setInput((Object)this.deployProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = this.deployProject.findMember((IPath)new Path(this.deployFolder));
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private void updateWidgets() {
        if (this.connection == null) {
            this.selectConnectionCombo(null);
        }
        this.setDomainComboInput(this.domains);
        this.selectDomainCombo(this.domain);
        this.setApplicationComboInput(this.applications);
        this.selectApplicationCombo(this.application);
        this.selectDeployProjectCombo(this.getImportedProjects(this.application, this.projectsByApplication));
        this.updateCreateOrImportLink();
        this.updateErrorMessage(null);
    }

    protected void setRemoteText(IApplication application, IProject deployProject) {
        if (application == null || !ProjectUtils.isAccessible((IProject)deployProject)) {
            this.remoteText.setEnabled(false);
            return;
        }
        String remoteName = this.getRemote(application, deployProject);
        this.remoteText.setText(remoteName);
        this.remoteText.setEnabled(!StringUtils.isEmpty((String)remoteName));
    }

    protected void setDeploymentFolderText(IApplication application, IProject deployProject) {
        if (application == null || !ProjectUtils.isAccessible((IProject)deployProject)) {
            this.deployFolderText.setEnabled(false);
            this.browseDeployFolderButton.setEnabled(false);
            return;
        }
        this.deployFolder = this.getDeployFolder(application, deployProject);
        this.deployFolderText.setText(StringUtils.null2emptyString((String)this.deployFolder));
        this.deployFolderText.setEnabled(!StringUtils.isEmpty((String)this.deployFolder));
        this.browseDeployFolderButton.setEnabled(true);
    }

    private void setDomainComboInput(List<IDomain> domains) {
        if (domains == null) {
            this.domainComboViewer.setInput(Collections.emptyList());
        } else {
            this.domainComboViewer.setInput(domains);
        }
    }

    private void setApplicationComboInput(List<IApplication> applications) {
        if (applications == null) {
            this.applicationComboViewer.setInput(Collections.emptyList());
        } else {
            this.applicationComboViewer.setInput(applications);
        }
    }

    private void updateCreateOrImportLink() {
        boolean enabled = true;
        if (this.application != null) {
            IProject[] p = OpenShiftServerUtils.findProjectsForApplication((IApplication)this.application);
            enabled = p == null || p.length == 0;
            this.importLink.setText(ExpressUIMessages.OpenShiftServerWizardImportLink);
        } else {
            this.importLink.setText(ExpressUIMessages.OpenShiftServerWizardCreateLink);
        }
        this.importLink.setEnabled(enabled);
    }

    private void updateErrorMessage(String message) {
        this.callback.setErrorMessage(this.createErrorMessage(message));
    }

    public String createErrorMessage() {
        return this.createErrorMessage(null);
    }

    public String createErrorMessage(String message) {
        String error = null;
        if (message != null) {
            error = message;
        } else if (this.connection == null) {
            error = ExpressUIMessages.OpenShiftServerWizardPleaseSelectConnection;
        } else if (this.domains == null) {
            error = NLS.bind((String)ExpressUIMessages.OpenShiftServerWizardPleaseCreateDomain, (Object)this.connection.getId());
        } else if (this.applications.isEmpty()) {
            error = ExpressUIMessages.OpenShiftServerWizardPleaseCreateApplication;
        } else if (this.application == null) {
            error = ExpressUIMessages.OpenShiftServerWizardPleaseSelectApplication;
        } else {
            IProject[] p = OpenShiftServerUtils.findProjectsForApplication((IApplication)this.application);
            if (p == null || p.length == 0) {
                error = NLS.bind((String)ExpressUIMessages.OpenShiftServerWizardYourWorkspaceDoesNotHaveProject, (Object)this.application.getName());
            }
        }
        return error;
    }

    private void updateModel(ExpressConnection connection, IDomain domain, IApplication application) {
        this.connection = connection;
        this.domains = this.safeGetDomains(connection);
        this.domain = this.getDomain(domain, this.domains);
        this.applications = this.safeGetApplications(this.domain);
        this.projectsByApplication = this.createProjectsByApplication(this.applications);
        this.application = this.getApplication(application, this.applications);
        this.deployProject = this.getDeployProject(this.application);
        this.deployFolder = this.getDeployFolder(this.application, this.deployProject);
        this.remote = this.getRemote(this.application, this.deployProject);
        this.configureServer(this.application, this.domain, this.remote, this.deployProject, this.deployFolder, this.callback.getServer());
    }

    protected IDomain getDomain(IDomain domain, List<IDomain> domains) {
        if (domain == null) {
            return this.getFirstDomain(domains);
        }
        if (domains != null && domains.indexOf(domain) == -1) {
            return this.getFirstDomain(domains);
        }
        return domain;
    }

    private IDomain getFirstDomain(List<IDomain> domains) {
        if (domains != null && domains.size() > 0) {
            return domains.get(0);
        }
        return null;
    }

    protected IApplication getApplication(IApplication application, List<IApplication> applications) {
        if (application == null) {
            return this.getFirstApplication(applications);
        }
        if (applications != null && applications.indexOf(application) == -1) {
            return this.getFirstApplication(applications);
        }
        return application;
    }

    private IProject getDeployProject(IApplication application) {
        if (application == null) {
            return null;
        }
        IProject[] projects = OpenShiftServerUtils.findProjectsForApplication((IApplication)application);
        if (projects == null || projects.length < 1) {
            return null;
        }
        return projects[0];
    }

    private List<IApplication> safeGetApplications(IDomain domain) {
        block3: {
            try {
                if (domain != null) break block3;
                return null;
            }
            catch (NotFoundOpenShiftException notFoundOpenShiftException) {
                return null;
            }
        }
        return domain.getApplications();
    }

    private List<IDomain> safeGetDomains(ExpressConnection connection) {
        block4: {
            if (connection != null) break block4;
            return null;
        }
        try {
            return connection.getDomains();
        }
        catch (NotFoundOpenShiftException notFoundOpenShiftException) {
            return Collections.emptyList();
        }
        catch (OpenShiftException e) {
            this.updateErrorMessage(NLS.bind((String)ExpressUIMessages.OpenShiftServerWizardCouldNotLoadDomains, (Object)connection.getId(), (Object)e.getMessage()));
            return null;
        }
    }

    private IApplication getFirstApplication(List<IApplication> applications) {
        IApplication application = null;
        if (applications != null && applications.size() > 0) {
            application = applications.get(0);
        }
        return application;
    }

    private Map<IApplication, IProject[]> createProjectsByApplication(List<IApplication> applications) {
        HashMap<IApplication, IProject[]> projectsByApplication = new HashMap<IApplication, IProject[]>();
        if (applications != null) {
            int i = 0;
            while (i < applications.size()) {
                projectsByApplication.put(applications.get(i), OpenShiftServerUtils.findProjectsForApplication((IApplication)applications.get(i)));
                ++i;
            }
        }
        return projectsByApplication;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.configureServer(this.application, this.domain, this.remote, this.deployProject, this.deployFolder, this.callback.getServer());
        this.updateProjectSettings(this.application, this.domain, this.remote, this.deployProject, this.deployFolder, this.connection);
    }

    private void configureServer(IApplication application, IDomain domain, String remote, IProject deployProject, String deployFolder, IServerWorkingCopy server) throws OpenShiftException {
        String serverName = OpenShiftServerUtils.getDefaultServerName((IApplication)application);
        OpenShiftServerUtils.fillServerWithOpenShiftDetails((IServerWorkingCopy)server, (String)serverName, (IProject)deployProject, (String)deployFolder, (String)remote, (IApplication)application, (IDomain)domain);
    }

    private void updateProjectSettings(IApplication application, IDomain domain, String remote, IProject deployProject, String deployFolder, ExpressConnection connection) {
        String projRemote = OpenShiftServerUtils.getProjectAttribute((IProject)deployProject, (String)"org.jboss.tools.openshift.RemoteName", null);
        String projDepFolder = OpenShiftServerUtils.getProjectAttribute((IProject)deployProject, (String)"org.jboss.tools.openshift.DeployFolder", null);
        if (projRemote == null && projDepFolder == null) {
            OpenShiftServerUtils.updateOpenshiftProjectSettings((IProject)deployProject, (IApplication)application, (IDomain)domain, (ExpressConnection)connection, (String)remote, (String)deployFolder);
        }
    }

    private void selectConnectionCombo(ExpressConnection connection) {
        StructuredSelection selection = new StructuredSelection();
        if (connection != null) {
            selection = new StructuredSelection((Object)connection);
        }
        this.connectionComboViewer.setSelection((ISelection)selection);
    }

    private void selectDomainCombo(IDomain domain) {
        StructuredSelection selection = new StructuredSelection();
        if (domain != null) {
            selection = new StructuredSelection((Object)domain);
        }
        this.domainComboViewer.setSelection((ISelection)selection);
    }

    protected void selectApplicationCombo(IApplication application) {
        StructuredSelection selection = new StructuredSelection();
        if (application != null) {
            selection = new StructuredSelection((Object)application);
        }
        this.applicationComboViewer.setSelection((ISelection)selection);
    }

    private void setDeployProjectCombo(IProject[] importedProjects) {
        this.deployProjectComboViewer.setInput((Object)importedProjects);
        this.selectDeployProjectCombo(importedProjects);
    }

    private void setDeployProjectCombo(IApplication application, Map<IApplication, IProject[]> projectsByApplication) {
        this.setDeployProjectCombo(this.getImportedProjects(application, projectsByApplication));
    }

    private IProject[] getImportedProjects(IApplication application, Map<IApplication, IProject[]> projectsByApplication) {
        IProject[] importedProjects = new IProject[]{};
        if (application != null) {
            importedProjects = projectsByApplication.get(application);
        }
        return importedProjects;
    }

    private void selectDeployProjectCombo(IProject[] importedProjects) {
        StructuredSelection selection = new StructuredSelection();
        if (importedProjects != null && importedProjects.length > 0) {
            selection = new StructuredSelection((Object)importedProjects[0]);
        }
        this.deployProjectComboViewer.setSelection((ISelection)selection);
    }

    private class UpdateModelJob
    extends Job {
        private ExpressConnection connection;
        private IDomain domain;
        private IApplication application;

        private UpdateModelJob(ExpressConnection connection, IDomain domain, IApplication application) {
            super(NLS.bind((String)ExpressUIMessages.OpenShiftServerWizardFetchingDomainsAndApplications, (Object)connection.getUsername()));
            this.connection = connection;
            this.domain = domain;
            this.application = application;
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenShiftServerWizardComposite.this.updateModel(this.connection, this.domain, this.application);
            return Status.OK_STATUS;
        }
    }
}

